/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.executionservice.impl;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.util.ExceptionUtil;
import java.util.concurrent.Executor;

class ScheduledTaskRunner
implements Runnable {
    private final Executor executor;
    private final Runnable runnable;
    private final ILogger logger = Logger.getLogger(this.getClass());

    public ScheduledTaskRunner(Runnable runnable, Executor executor) {
        this.executor = executor;
        this.runnable = runnable;
    }

    @Override
    public void run() {
        try {
            this.executor.execute(this.runnable);
        }
        catch (Throwable t) {
            this.logger.severe("Cannot execute " + this.runnable, t);
            ExceptionUtil.sneakyThrow(t);
        }
    }
}

