/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp;

import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionType;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.tcp.ReadHandler;
import com.hazelcast.util.StringUtil;
import java.nio.ByteBuffer;

public class OldClientReadHandler
implements ReadHandler {
    private final Connection connection;
    private final IOService ioService;
    private Packet packet;
    private boolean connectionTypeSet;

    public OldClientReadHandler(Connection connection, IOService ioService) {
        this.connection = connection;
        this.ioService = ioService;
    }

    @Override
    public void onRead(ByteBuffer src) throws Exception {
        while (src.hasRemaining()) {
            boolean complete;
            if (!this.connectionTypeSet) {
                if (!this.setConnectionType(src)) {
                    return;
                }
                this.connectionTypeSet = true;
            }
            if (this.packet == null) {
                this.packet = new Packet();
            }
            if (!(complete = this.packet.readFrom(src))) break;
            this.packet.setConn(this.connection);
            this.ioService.handleClientPacket(this.packet);
            this.packet = null;
        }
    }

    private boolean setConnectionType(ByteBuffer inBuffer) {
        if (inBuffer.remaining() < 3) {
            return false;
        }
        byte[] typeBytes = new byte[3];
        inBuffer.get(typeBytes);
        String type = StringUtil.bytesToString(typeBytes);
        if ("JVM".equals(type)) {
            this.connection.setType(ConnectionType.JAVA_CLIENT);
        } else if ("CSP".equals(type)) {
            this.connection.setType(ConnectionType.CSHARP_CLIENT);
        } else if ("CPP".equals(type)) {
            this.connection.setType(ConnectionType.CPP_CLIENT);
        } else if ("PYH".equals(type)) {
            this.connection.setType(ConnectionType.PYTHON_CLIENT);
        } else if ("RBY".equals(type)) {
            this.connection.setType(ConnectionType.RUBY_CLIENT);
        } else {
            this.ioService.getLogger(this.getClass().getName()).info("Unknown client type: " + type);
            this.connection.setType(ConnectionType.BINARY_CLIENT);
        }
        return true;
    }
}

