/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.ClientEngine;
import com.hazelcast.client.impl.ClientEndpointImpl;
import com.hazelcast.client.impl.ClientEndpointManagerImpl;
import com.hazelcast.core.ClientType;
import com.hazelcast.instance.GroupProperties;
import com.hazelcast.instance.GroupProperty;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.util.Clock;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class ClientHeartbeatMonitor
implements Runnable {
    private static final int HEART_BEAT_CHECK_INTERVAL_SECONDS = 10;
    private static final int DEFAULT_CLIENT_HEARTBEAT_TIMEOUT_SECONDS = 60;
    private final ClientEndpointManagerImpl clientEndpointManager;
    private final ClientEngine clientEngine;
    private final long heartbeatTimeoutSeconds;
    private final ILogger logger = Logger.getLogger(ClientHeartbeatMonitor.class);
    private final ExecutionService executionService;

    public ClientHeartbeatMonitor(ClientEndpointManagerImpl endpointManager, ClientEngine clientEngine, ExecutionService executionService, GroupProperties groupProperties) {
        this.clientEndpointManager = endpointManager;
        this.clientEngine = clientEngine;
        this.executionService = executionService;
        this.heartbeatTimeoutSeconds = this.getHeartBeatTimeout(groupProperties);
    }

    private long getHeartBeatTimeout(GroupProperties groupProperties) {
        long configuredTimeout = groupProperties.getSeconds(GroupProperty.CLIENT_HEARTBEAT_TIMEOUT_SECONDS);
        if (configuredTimeout > 0L) {
            return configuredTimeout;
        }
        return 60L;
    }

    public void start() {
        this.executionService.scheduleWithFixedDelay(this, 10L, 10L, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        String memberUuid = this.clientEngine.getLocalMember().getUuid();
        for (ClientEndpoint ce : this.clientEndpointManager.getEndpoints()) {
            ClientEndpointImpl clientEndpoint = (ClientEndpointImpl)ce;
            this.monitor(memberUuid, clientEndpoint);
        }
    }

    private void monitor(String memberUuid, ClientEndpointImpl clientEndpoint) {
        long currentTimeInMillis;
        long timeoutInMillis;
        if (clientEndpoint.isFirstConnection() && ClientType.CPP.equals((Object)clientEndpoint.getClientType())) {
            return;
        }
        Connection connection = clientEndpoint.getConnection();
        long lastTimePackageReceived = connection.lastReadTimeMillis();
        if (lastTimePackageReceived + (timeoutInMillis = TimeUnit.SECONDS.toMillis(this.heartbeatTimeoutSeconds)) < (currentTimeInMillis = Clock.currentTimeMillis()) && memberUuid.equals(clientEndpoint.getPrincipal().getOwnerUuid())) {
            this.logger.log(Level.WARNING, "Client heartbeat is timed out , closing connection to " + connection);
            connection.close();
        }
    }
}

