/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl.client;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.replicatedmap.impl.client.AbstractReplicatedMapClientRequest;
import com.hazelcast.replicatedmap.impl.operation.ContainsValueOperation;
import com.hazelcast.security.permission.ReplicatedMapPermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;

public class ClientReplicatedMapContainsValueRequest
extends AbstractReplicatedMapClientRequest {
    private Data value;

    ClientReplicatedMapContainsValueRequest() {
        super(null);
    }

    public ClientReplicatedMapContainsValueRequest(String mapName, Data value, int partitionId) {
        super(mapName, partitionId);
        this.value = value;
    }

    @Override
    protected Operation prepareOperation() {
        return new ContainsValueOperation(this.getMapName(), this.value);
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeData(this.value);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        ObjectDataInput in = reader.getRawDataInput();
        this.value = in.readData();
    }

    @Override
    public int getClassId() {
        return 4;
    }

    @Override
    public Permission getRequiredPermission() {
        return new ReplicatedMapPermission(this.getMapName(), "read");
    }

    @Override
    public String getMethodName() {
        return "containsValue";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.value};
    }
}

