/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.event.MapEventPublisher;
import com.hazelcast.map.impl.operation.EvictAllBackupOperation;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.impl.MutatingOperation;
import java.io.IOException;

public class EvictAllOperation
extends MapOperation
implements BackupAwareOperation,
MutatingOperation,
PartitionAwareOperation {
    private boolean shouldRunOnBackup;
    private int numberOfEvictedEntries;

    public EvictAllOperation() {
    }

    public EvictAllOperation(String name) {
        super(name);
    }

    @Override
    public void run() throws Exception {
        this.clearLocalNearCache();
        RecordStore recordStore = this.mapServiceContext.getExistingRecordStore(this.getPartitionId(), this.name);
        if (recordStore == null) {
            return;
        }
        this.numberOfEvictedEntries = recordStore.evictAll(false);
        this.shouldRunOnBackup = true;
    }

    @Override
    public void afterRun() throws Exception {
        super.afterRun();
        this.hintMapEvent();
    }

    private void hintMapEvent() {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        MapEventPublisher mapEventPublisher = mapServiceContext.getMapEventPublisher();
        mapEventPublisher.hintMapEvent(this.getCallerAddress(), this.name, EntryEventType.EVICT_ALL, this.numberOfEvictedEntries, this.getPartitionId());
    }

    @Override
    public boolean shouldBackup() {
        return this.shouldRunOnBackup;
    }

    @Override
    public Object getResponse() {
        return this.numberOfEvictedEntries;
    }

    @Override
    public int getSyncBackupCount() {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        return mapServiceContext.getMapContainer(this.name).getBackupCount();
    }

    @Override
    public int getAsyncBackupCount() {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        return mapServiceContext.getMapContainer(this.name).getAsyncBackupCount();
    }

    @Override
    public Operation getBackupOperation() {
        return new EvictAllBackupOperation(this.name);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.numberOfEvictedEntries);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.numberOfEvictedEntries = in.readInt();
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", shouldRunOnBackup=").append(this.shouldRunOnBackup);
        sb.append(", numberOfEvictedEntries=").append(this.numberOfEvictedEntries);
    }
}

