/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster.impl;

import com.hazelcast.cluster.ClusterService;
import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.Joiner;
import com.hazelcast.cluster.impl.ClusterJoinManager;
import com.hazelcast.cluster.impl.ClusterServiceImpl;
import com.hazelcast.cluster.impl.JoinMessage;
import com.hazelcast.cluster.impl.operations.JoinCheckOperation;
import com.hazelcast.cluster.impl.operations.MemberRemoveOperation;
import com.hazelcast.cluster.impl.operations.MergeClustersOperation;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.config.Config;
import com.hazelcast.core.Member;
import com.hazelcast.instance.GroupProperty;
import com.hazelcast.instance.Node;
import com.hazelcast.instance.NodeState;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.OperationResponseHandlerFactory;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import com.hazelcast.util.Clock;
import com.hazelcast.util.EmptyStatement;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractJoiner
implements Joiner {
    private static final long SPLIT_BRAIN_CONN_TIMEOUT = 5000L;
    private static final long SPLIT_BRAIN_SLEEP_TIME = 10L;
    private final AtomicLong joinStartTime = new AtomicLong(Clock.currentTimeMillis());
    private final AtomicInteger tryCount = new AtomicInteger(0);
    protected final ConcurrentMap<Address, Boolean> blacklistedAddresses = new ConcurrentHashMap<Address, Boolean>();
    protected final Config config;
    protected final Node node;
    protected final ClusterServiceImpl clusterService;
    protected final ClusterJoinManager clusterJoinManager;
    protected final ILogger logger;
    private final long mergeNextRunDelayMs;
    private volatile Address targetAddress;

    public AbstractJoiner(Node node) {
        this.node = node;
        this.logger = node.loggingService.getLogger(this.getClass());
        this.config = node.config;
        this.clusterService = node.getClusterService();
        this.clusterJoinManager = this.clusterService.getClusterJoinManager();
        this.mergeNextRunDelayMs = node.groupProperties.getMillis(GroupProperty.MERGE_NEXT_RUN_DELAY_SECONDS);
    }

    @Override
    public void blacklist(Address address, boolean permanent) {
        this.logger.info(address + " is added to the blacklist.");
        this.blacklistedAddresses.putIfAbsent(address, permanent);
    }

    @Override
    public boolean unblacklist(Address address) {
        if (this.blacklistedAddresses.remove(address, Boolean.FALSE)) {
            this.logger.info(address + " is removed from the blacklist.");
            return true;
        }
        return false;
    }

    @Override
    public boolean isBlacklisted(Address address) {
        return this.blacklistedAddresses.containsKey(address);
    }

    public abstract void doJoin();

    @Override
    public final void join() {
        this.blacklistedAddresses.clear();
        this.doJoin();
        this.postJoin();
    }

    private void postJoin() {
        this.blacklistedAddresses.clear();
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("PostJoin master: " + this.node.getMasterAddress() + ", isMaster: " + this.node.isMaster());
        }
        if (this.node.getState() != NodeState.ACTIVE) {
            return;
        }
        if (this.tryCount.incrementAndGet() == 5) {
            this.logger.warning("Join try count exceed limit, setting this node as master!");
            this.node.setAsMaster();
        }
        if (this.node.joined()) {
            if (!this.node.isMaster()) {
                this.ensureConnectionToAllMembers();
            }
            if (this.clusterService.getSize() == 1) {
                this.logger.info('\n' + this.node.clusterService.membersString());
            }
        }
    }

    private void ensureConnectionToAllMembers() {
        boolean allConnected = false;
        if (this.node.joined()) {
            this.logger.finest("Waiting for all connections");
            int connectAllWaitSeconds = this.node.groupProperties.getSeconds(GroupProperty.CONNECT_ALL_WAIT_SECONDS);
            int checkCount = 0;
            while (checkCount++ < connectAllWaitSeconds && !allConnected) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                allConnected = true;
                Set<Member> members = this.clusterService.getMembers();
                for (Member member : members) {
                    if (member.localMember() || this.node.connectionManager.getOrConnect(member.getAddress()) != null) continue;
                    allConnected = false;
                    if (!this.logger.isFinestEnabled()) continue;
                    this.logger.finest("Not-connected to " + member.getAddress());
                }
            }
        }
    }

    protected final long getMaxJoinMillis() {
        return this.node.getGroupProperties().getMillis(GroupProperty.MAX_JOIN_SECONDS);
    }

    protected final long getMaxJoinTimeToMasterNode() {
        return TimeUnit.SECONDS.toMillis(10L) + this.node.getGroupProperties().getMillis(GroupProperty.MAX_WAIT_SECONDS_BEFORE_JOIN);
    }

    boolean shouldMerge(JoinMessage joinMessage) {
        if (joinMessage == null) {
            return false;
        }
        try {
            boolean validJoinRequest = this.clusterJoinManager.validateJoinMessage(joinMessage);
            if (!validJoinRequest) {
                this.logger.finest("Cannot process split brain merge message from " + joinMessage.getAddress() + ", since join-message could not be validated.");
                return false;
            }
        }
        catch (Exception e) {
            this.logger.finest(e.getMessage());
            return false;
        }
        try {
            int currentDataMemberCount;
            if (this.clusterService.getMember(joinMessage.getAddress()) != null) {
                if (this.logger.isFinestEnabled()) {
                    this.logger.finest("Should not merge to " + joinMessage.getAddress() + ", because it is already member of this cluster.");
                }
                return false;
            }
            ClusterState clusterState = this.clusterService.getClusterState();
            if (clusterState != ClusterState.ACTIVE) {
                if (this.logger.isFinestEnabled()) {
                    this.logger.finest("Should not merge to " + joinMessage.getAddress() + ", because this cluster is in " + (Object)((Object)clusterState) + " state.");
                }
                return false;
            }
            Collection<Address> targetMemberAddresses = joinMessage.getMemberAddresses();
            if (targetMemberAddresses.contains(this.node.getThisAddress())) {
                this.node.nodeEngine.getOperationService().send(new MemberRemoveOperation(this.node.getThisAddress()), joinMessage.getAddress());
                this.logger.info(this.node.getThisAddress() + " CANNOT merge to " + joinMessage.getAddress() + ", because it thinks this-node as its member.");
                return false;
            }
            Collection<Address> thisMemberAddresses = this.clusterService.getMemberAddresses();
            for (Address address : thisMemberAddresses) {
                if (!targetMemberAddresses.contains(address)) continue;
                this.logger.info(this.node.getThisAddress() + " CANNOT merge to " + joinMessage.getAddress() + ", because it thinks " + address + " as its member. " + "But " + address + " is member of this cluster.");
                return false;
            }
            int targetDataMemberCount = joinMessage.getDataMemberCount();
            if (targetDataMemberCount > (currentDataMemberCount = this.clusterService.getSize(MemberSelectors.DATA_MEMBER_SELECTOR))) {
                this.logger.info(this.node.getThisAddress() + " is merging to " + joinMessage.getAddress() + ", because : joinMessage.getDataMemberCount() > currentDataMemberCount [" + targetDataMemberCount + " > " + currentDataMemberCount + ']');
                if (this.logger.isFinestEnabled()) {
                    this.logger.finest(joinMessage.toString());
                }
                return true;
            }
            if (targetDataMemberCount == currentDataMemberCount) {
                if (this.node.getThisAddress().hashCode() > joinMessage.getAddress().hashCode()) {
                    this.logger.info(this.node.getThisAddress() + " is merging to " + joinMessage.getAddress() + ", because : node.getThisAddress().hashCode() > joinMessage.address.hashCode() " + ", this node member count: " + currentDataMemberCount);
                    if (this.logger.isFinestEnabled()) {
                        this.logger.finest(joinMessage.toString());
                    }
                    return true;
                }
                this.logger.info(joinMessage.getAddress() + " should merge to this node " + ", because : node.getThisAddress().hashCode() < joinMessage.address.hashCode() " + ", this node data member count: " + currentDataMemberCount);
            } else {
                this.logger.info(joinMessage.getAddress() + " should merge to this node " + ", because : currentDataMemberCount > joinMessage.getDataMemberCount() [" + currentDataMemberCount + " > " + targetDataMemberCount + ']');
            }
        }
        catch (Throwable e) {
            this.logger.severe(e);
        }
        return false;
    }

    JoinMessage sendSplitBrainJoinMessage(Address target) {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest(this.node.getThisAddress() + " is connecting to " + target);
        }
        Connection conn = this.node.connectionManager.getOrConnect(target, true);
        long timeout = 5000L;
        while (conn == null) {
            if ((timeout -= 10L) < 0L) {
                return null;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                EmptyStatement.ignore(e);
                return null;
            }
            conn = this.node.connectionManager.getConnection(target);
        }
        NodeEngineImpl nodeEngine = this.node.nodeEngine;
        InternalCompletableFuture f = nodeEngine.getOperationService().createInvocationBuilder("hz:core:clusterService", (Operation)new JoinCheckOperation(this.node.createSplitBrainJoinMessage()), target).setTryCount(1).invoke();
        try {
            return (JoinMessage)f.get(10L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            this.logger.finest("Timeout during join check!", e);
        }
        catch (Exception e) {
            this.logger.warning("Error during join check!", e);
        }
        return null;
    }

    @Override
    public void reset() {
        this.joinStartTime.set(Clock.currentTimeMillis());
        this.tryCount.set(0);
    }

    protected void startClusterMerge(Address targetAddress) {
        ClusterServiceImpl clusterService = this.node.clusterService;
        if (!this.prepareClusterState(clusterService)) {
            return;
        }
        InternalOperationService operationService = this.node.nodeEngine.getOperationService();
        Set<Member> memberList = clusterService.getMembers();
        for (Member member : memberList) {
            if (member.localMember()) continue;
            MergeClustersOperation op = new MergeClustersOperation(targetAddress);
            operationService.invokeOnTarget("hz:core:clusterService", op, member.getAddress());
        }
        MergeClustersOperation mergeClustersOperation = new MergeClustersOperation(targetAddress);
        mergeClustersOperation.setNodeEngine(this.node.nodeEngine).setService(clusterService).setOperationResponseHandler(OperationResponseHandlerFactory.createEmptyResponseHandler());
        operationService.runOperationOnCallingThread(mergeClustersOperation);
    }

    private boolean prepareClusterState(ClusterServiceImpl clusterService) {
        if (!this.preCheckClusterState(clusterService)) {
            return false;
        }
        long until = Clock.currentTimeMillis() + this.mergeNextRunDelayMs;
        while (clusterService.getClusterState() == ClusterState.ACTIVE) {
            try {
                clusterService.changeClusterState(ClusterState.FROZEN);
                return true;
            }
            catch (Exception e) {
                String error = e.getClass().getName() + ": " + e.getMessage();
                this.logger.warning("While freezing cluster state! " + error);
                if (Clock.currentTimeMillis() >= until) {
                    this.logger.warning("Could not change cluster state to FROZEN in time. Postponing merge process until next attempt.");
                    return false;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e2) {
                    this.logger.warning("Interrupted while preparing cluster for merge!");
                    Thread.currentThread().interrupt();
                    return false;
                }
            }
        }
        return false;
    }

    private boolean preCheckClusterState(ClusterService clusterService) {
        ClusterState initialState = clusterService.getClusterState();
        if (initialState != ClusterState.ACTIVE) {
            this.logger.warning("Could not prepare cluster state since it has been changed to " + (Object)((Object)initialState));
            return false;
        }
        return true;
    }

    @Override
    public final long getStartTime() {
        return this.joinStartTime.get();
    }

    @Override
    public void setTargetAddress(Address targetAddress) {
        this.targetAddress = targetAddress;
    }

    public Address getTargetAddress() {
        Address target = this.targetAddress;
        this.targetAddress = null;
        return target;
    }
}

