/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.client;

import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.map.impl.MapPortableHook;
import com.hazelcast.map.impl.client.MapPartitionClientRequest;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;
import java.util.HashMap;
import java.util.Map;

public class MapPutAllRequest
extends MapPartitionClientRequest
implements Portable,
SecureRequest {
    private MapEntries entries;
    private int partitionId;

    public MapPutAllRequest() {
    }

    public MapPutAllRequest(String name, MapEntries entries, int partitionId) {
        super(name);
        this.entries = entries;
        this.partitionId = partitionId;
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 40;
    }

    @Override
    protected Operation prepareOperation() {
        MapOperation operation = this.getOperationProvider().createPutAllOperation(this.name, this.entries, false);
        operation.setPartitionId(this.partitionId);
        return operation;
    }

    @Override
    protected int getPartition() {
        return this.partitionId;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeInt("p", this.partitionId);
        ObjectDataOutput output = writer.getRawDataOutput();
        this.entries.writeData(output);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.partitionId = reader.readInt("p");
        ObjectDataInput input = reader.getRawDataInput();
        this.entries = new MapEntries();
        this.entries.readData(input);
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "put");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public String getMethodName() {
        return "putAll";
    }

    @Override
    public Object[] getParameters() {
        HashMap<Data, Data> map = new HashMap<Data, Data>();
        for (Map.Entry<Data, Data> entry : this.entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        return new Object[]{map};
    }
}

