/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.client;

import com.hazelcast.client.impl.client.CallableClientRequest;
import com.hazelcast.client.impl.client.ClientPortableHook;
import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.partition.client.PartitionsResponse;
import java.security.Permission;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class GetPartitionsRequest
extends CallableClientRequest
implements Portable,
RetryableRequest {
    public Object call() throws Exception {
        InternalPartitionService service = (InternalPartitionService)this.getService();
        service.firstArrangement();
        InternalPartition[] partitions = service.getPartitions();
        int[] indexes = new int[partitions.length];
        HashMap<Address, HashSet<Integer>> partitionsMap = new HashMap<Address, HashSet<Integer>>();
        for (InternalPartition partition : partitions) {
            Address owner = partition.getOwnerOrNull();
            if (owner == null) {
                return null;
            }
            HashSet<Integer> ownedPartitions = (HashSet<Integer>)partitionsMap.get(owner);
            if (ownedPartitions == null) {
                ownedPartitions = new HashSet<Integer>();
                partitionsMap.put(owner, ownedPartitions);
            }
            ownedPartitions.add(partition.getPartitionId());
        }
        Address[] addresses = new Address[partitionsMap.size()];
        int k = 0;
        for (Address owner : partitionsMap.keySet()) {
            addresses[k++] = owner;
        }
        for (k = 0; k < addresses.length; ++k) {
            Set ownedPartitions = (Set)partitionsMap.get(addresses[k]);
            Iterator i$ = ownedPartitions.iterator();
            while (i$.hasNext()) {
                int partitionId = (Integer)i$.next();
                indexes[partitionId] = k;
            }
        }
        return new PartitionsResponse(addresses, indexes);
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    public int getFactoryId() {
        return ClientPortableHook.ID;
    }

    @Override
    public int getClassId() {
        return 12;
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

