/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.util.ExceptionUtil;

public final class Clock {
    public static final String HAZELCAST_CLOCK_OFFSET = "com.hazelcast.clock.offset";
    public static final String HAZELCAST_CLOCK_IMPL = "com.hazelcast.clock.impl";
    private static final ClockImpl CLOCK = Clock.initClock();

    private Clock() {
    }

    public static long currentTimeMillis() {
        return CLOCK.currentTimeMillis();
    }

    private static ClockImpl initClock() {
        String clockImplClassName = System.getProperty(HAZELCAST_CLOCK_IMPL);
        if (clockImplClassName != null) {
            try {
                return (ClockImpl)ClassLoaderUtil.newInstance(null, clockImplClassName);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        String clockOffset = System.getProperty(HAZELCAST_CLOCK_OFFSET);
        long offset = 0L;
        if (clockOffset != null) {
            try {
                offset = Long.parseLong(clockOffset);
            }
            catch (NumberFormatException e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        if (offset != 0L) {
            return new SystemOffsetClock(offset);
        }
        return new SystemClock();
    }

    private static final class SystemOffsetClock
    extends ClockImpl {
        private final long offset;

        private SystemOffsetClock(long offset) {
            this.offset = offset;
        }

        @Override
        protected long currentTimeMillis() {
            return System.currentTimeMillis() + this.offset;
        }

        public String toString() {
            return "SystemOffsetClock{offset=" + this.offset + '}';
        }
    }

    private static final class SystemClock
    extends ClockImpl {
        private SystemClock() {
        }

        @Override
        protected long currentTimeMillis() {
            return System.currentTimeMillis();
        }

        public String toString() {
            return "SystemClock";
        }
    }

    public static abstract class ClockImpl {
        protected abstract long currentTimeMillis();
    }
}

