/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationexecutor.classic;

import com.hazelcast.instance.HazelcastThreadGroup;
import com.hazelcast.instance.NodeExtension;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Packet;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.PartitionSpecificRunnable;
import com.hazelcast.spi.impl.operationexecutor.OperationRunner;
import com.hazelcast.spi.impl.operationexecutor.classic.ScheduleQueue;
import com.hazelcast.util.counters.SwCounter;
import com.hazelcast.util.executor.HazelcastManagedThread;
import java.util.concurrent.TimeUnit;

public abstract class OperationThread
extends HazelcastManagedThread {
    final int threadId;
    final ScheduleQueue scheduleQueue;
    @Probe
    private final SwCounter processedTotalCount = SwCounter.newSwCounter();
    @Probe
    private final SwCounter processedPacketCount = SwCounter.newSwCounter();
    @Probe
    private final SwCounter processedOperationsCount = SwCounter.newSwCounter();
    @Probe
    private final SwCounter processedPartitionSpecificRunnableCount = SwCounter.newSwCounter();
    @Probe
    private final SwCounter processedRunnableCount = SwCounter.newSwCounter();
    private final NodeExtension nodeExtension;
    private final ILogger logger;
    private volatile boolean shutdown;
    private OperationRunner currentOperationRunner;

    public OperationThread(String name, int threadId, ScheduleQueue scheduleQueue, ILogger logger, HazelcastThreadGroup threadGroup, NodeExtension nodeExtension) {
        super(threadGroup.getInternalThreadGroup(), name);
        this.setContextClassLoader(threadGroup.getClassLoader());
        this.scheduleQueue = scheduleQueue;
        this.threadId = threadId;
        this.logger = logger;
        this.nodeExtension = nodeExtension;
    }

    @Probe
    int priorityPendingCount() {
        return this.scheduleQueue.prioritySize();
    }

    @Probe
    int normalPendingCount() {
        return this.scheduleQueue.normalSize();
    }

    public OperationRunner getCurrentOperationRunner() {
        return this.currentOperationRunner;
    }

    public abstract OperationRunner getOperationRunner(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        this.nodeExtension.onThreadStart(this);
        try {
            this.doRun();
        }
        catch (Throwable t) {
            OutOfMemoryErrorDispatcher.inspectOutputMemoryError(t);
            this.logger.severe(t);
        }
        finally {
            this.nodeExtension.onThreadStop(this);
        }
    }

    private void doRun() {
        while (true) {
            Object task;
            try {
                task = this.scheduleQueue.take();
            }
            catch (InterruptedException e) {
                if (!this.shutdown) continue;
                return;
            }
            if (this.shutdown) {
                return;
            }
            this.process(task);
        }
    }

    private void process(Object task) {
        this.processedTotalCount.inc();
        if (task instanceof Operation) {
            this.processOperation((Operation)task);
            return;
        }
        if (task instanceof Packet) {
            this.processPacket((Packet)task);
            return;
        }
        if (task instanceof PartitionSpecificRunnable) {
            this.processPartitionSpecificRunnable((PartitionSpecificRunnable)task);
            return;
        }
        if (task instanceof Runnable) {
            this.processRunnable((Runnable)task);
            return;
        }
        throw new IllegalStateException("Unhandled task type for task:" + task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPartitionSpecificRunnable(PartitionSpecificRunnable runnable) {
        this.processedPartitionSpecificRunnableCount.inc();
        try {
            this.currentOperationRunner = this.getOperationRunner(runnable.getPartitionId());
            this.currentOperationRunner.run(runnable);
        }
        catch (Throwable e) {
            OutOfMemoryErrorDispatcher.inspectOutputMemoryError(e);
            this.logger.severe("Failed to process task: " + runnable + " on " + this.getName(), e);
        }
        finally {
            this.currentOperationRunner = null;
        }
    }

    private void processRunnable(Runnable runnable) {
        this.processedRunnableCount.inc();
        try {
            runnable.run();
        }
        catch (Throwable e) {
            OutOfMemoryErrorDispatcher.inspectOutputMemoryError(e);
            this.logger.severe("Failed to process task: " + runnable + " on " + this.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPacket(Packet packet) {
        this.processedPacketCount.inc();
        try {
            this.currentOperationRunner = this.getOperationRunner(packet.getPartitionId());
            this.currentOperationRunner.run(packet);
        }
        catch (Throwable e) {
            OutOfMemoryErrorDispatcher.inspectOutputMemoryError(e);
            this.logger.severe("Failed to process packet: " + packet + " on " + this.getName(), e);
        }
        finally {
            this.currentOperationRunner = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOperation(Operation operation) {
        this.processedOperationsCount.inc();
        try {
            this.currentOperationRunner = this.getOperationRunner(operation.getPartitionId());
            this.currentOperationRunner.run(operation);
        }
        catch (Throwable e) {
            OutOfMemoryErrorDispatcher.inspectOutputMemoryError(e);
            this.logger.severe("Failed to process operation: " + operation + " on " + this.getName(), e);
        }
        finally {
            this.currentOperationRunner = null;
        }
    }

    public final void shutdown() {
        this.shutdown = true;
        this.interrupt();
    }

    public final void awaitTermination(int timeout, TimeUnit unit) throws InterruptedException {
        long timeoutMs = unit.toMillis(timeout);
        this.join(timeoutMs);
    }

    public int getThreadId() {
        return this.threadId;
    }
}

