/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ringbuffer.impl;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.ringbuffer.StaleSequenceException;
import com.hazelcast.ringbuffer.impl.ReadResultSetImpl;
import com.hazelcast.ringbuffer.impl.RingbufferWaitNotifyKey;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class RingbufferContainer
implements DataSerializable {
    private static final long TTL_DISABLED = 0L;
    Object[] ringItems;
    long[] ringExpirationMs;
    InMemoryFormat inMemoryFormat;
    long ttlMs;
    RingbufferConfig config;
    String name;
    long tailSequence = -1L;
    long headSequence = this.tailSequence + 1L;
    int capacity;
    private final RingbufferWaitNotifyKey emptyRingWaitNotifyKey;
    private SerializationService serializationService;

    public RingbufferContainer(String name) {
        this.name = name;
        this.emptyRingWaitNotifyKey = new RingbufferWaitNotifyKey(name, "empty");
    }

    public RingbufferContainer(RingbufferConfig config, SerializationService serializationService) {
        this(config.getName(), config, serializationService);
    }

    public RingbufferContainer(String name, RingbufferConfig config, SerializationService serializationService) {
        this(name);
        this.serializationService = serializationService;
        this.config = config;
        this.capacity = config.getCapacity();
        this.inMemoryFormat = config.getInMemoryFormat();
        this.ringItems = new Object[this.capacity];
        this.ttlMs = TimeUnit.SECONDS.toMillis(config.getTimeToLiveSeconds());
        if (this.isTTLEnabled()) {
            this.ringExpirationMs = new long[this.capacity];
        }
    }

    public void init(NodeEngine nodeEngine) {
        this.config = nodeEngine.getConfig().getRingbufferConfig(this.name);
        this.serializationService = nodeEngine.getSerializationService();
    }

    public RingbufferWaitNotifyKey getRingEmptyWaitNotifyKey() {
        return this.emptyRingWaitNotifyKey;
    }

    public RingbufferConfig getConfig() {
        return this.config;
    }

    public long tailSequence() {
        return this.tailSequence;
    }

    public long headSequence() {
        return this.headSequence;
    }

    public void setHeadSequence(long sequence) {
        this.headSequence = sequence;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public long size() {
        return this.tailSequence - this.headSequence + 1L;
    }

    public boolean isEmpty() {
        return this.size() == 0L;
    }

    public boolean shouldWait(long sequence) {
        this.checkBlockableReadSequence(sequence);
        return sequence == this.tailSequence + 1L;
    }

    public long remainingCapacity() {
        if (this.isTTLEnabled()) {
            return (long)this.capacity - this.size();
        }
        return this.capacity;
    }

    private boolean isTTLEnabled() {
        return this.ttlMs != 0L;
    }

    int toIndex(long sequence) {
        return (int)(sequence % (long)this.ringItems.length);
    }

    void checkReadSequence(long sequence) {
        if (sequence > this.tailSequence) {
            throw new IllegalArgumentException("sequence:" + sequence + " is too large. The current tailSequence is:" + this.tailSequence);
        }
        if (sequence < this.headSequence) {
            throw new StaleSequenceException("sequence:" + sequence + " is too small. The current headSequence is:" + this.headSequence + " tailSequence is:" + this.tailSequence, this.headSequence);
        }
    }

    public void checkBlockableReadSequence(long readSequence) {
        if (readSequence > this.tailSequence + 1L) {
            throw new IllegalArgumentException("sequence:" + readSequence + " is too large. The current tailSequence is:" + this.tailSequence);
        }
        if (readSequence < this.headSequence) {
            throw new StaleSequenceException("sequence:" + readSequence + " is too small. The current headSequence is:" + this.headSequence + " tailSequence is:" + this.tailSequence, this.headSequence);
        }
    }

    public long add(Data item) {
        return this.addInternal(item);
    }

    private long addInternal(Data dataItem) {
        ++this.tailSequence;
        if (this.tailSequence - (long)this.capacity == this.headSequence) {
            ++this.headSequence;
        }
        int index = this.toIndex(this.tailSequence);
        Data item = dataItem;
        if (this.inMemoryFormat == InMemoryFormat.OBJECT) {
            item = this.serializationService.toObject(dataItem);
        }
        this.ringItems[index] = item;
        if (this.isTTLEnabled()) {
            this.ringExpirationMs[index] = Clock.currentTimeMillis() + this.ttlMs;
        }
        return this.tailSequence;
    }

    public long addAll(Data[] items) {
        long result = -1L;
        for (Data item : items) {
            result = this.addInternal(item);
        }
        return result;
    }

    public Data read(long sequence) {
        this.checkReadSequence(sequence);
        int index = this.toIndex(sequence);
        Object item = this.ringItems[index];
        return this.serializationService.toData(item);
    }

    public long readMany(long beginSequence, ReadResultSetImpl result) {
        long seq;
        this.checkReadSequence(beginSequence);
        for (seq = beginSequence; seq <= this.tailSequence; ++seq) {
            int index = this.toIndex(seq);
            Object item = this.ringItems[index];
            result.addItem(item);
            if (!result.isMaxSizeReached()) continue;
            break;
        }
        return seq;
    }

    public void cleanup() {
        if (!this.isTTLEnabled() || this.headSequence > this.tailSequence) {
            return;
        }
        long now = Clock.currentTimeMillis();
        while (this.headSequence <= this.tailSequence) {
            int index = this.toIndex(this.headSequence);
            if (this.ringExpirationMs[index] > now) {
                return;
            }
            this.ringItems[index] = null;
            ++this.headSequence;
        }
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.tailSequence);
        out.writeLong(this.headSequence);
        out.writeInt(this.capacity);
        out.writeLong(this.ttlMs);
        out.writeInt(this.inMemoryFormat.ordinal());
        boolean ttlEnabled = this.isTTLEnabled();
        long now = System.currentTimeMillis();
        for (long seq = this.headSequence; seq <= this.tailSequence; ++seq) {
            int index = this.toIndex(seq);
            if (this.inMemoryFormat == InMemoryFormat.BINARY) {
                out.writeData((Data)this.ringItems[index]);
            } else {
                out.writeObject(this.ringItems[index]);
            }
            if (!ttlEnabled) continue;
            long deltaMs = this.ringExpirationMs[index] - now;
            out.writeLong(deltaMs);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.tailSequence = in.readLong();
        this.headSequence = in.readLong();
        this.capacity = in.readInt();
        this.ttlMs = in.readLong();
        this.inMemoryFormat = InMemoryFormat.values()[in.readInt()];
        this.ringItems = new Object[this.capacity];
        boolean ttlEnabled = this.isTTLEnabled();
        if (ttlEnabled) {
            this.ringExpirationMs = new long[this.capacity];
        }
        long now = System.currentTimeMillis();
        for (long seq = this.headSequence; seq <= this.tailSequence; ++seq) {
            int index = this.toIndex(seq);
            this.ringItems[index] = this.inMemoryFormat == InMemoryFormat.BINARY ? in.readData() : in.readObject();
            if (!ttlEnabled) continue;
            long delta = in.readLong();
            this.ringExpirationMs[index] = delta + now;
        }
    }
}

