/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.monitor.impl;

import com.hazelcast.com.eclipsesource.json.JsonObject;
import com.hazelcast.com.eclipsesource.json.JsonValue;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.NearCacheStats;
import com.hazelcast.monitor.impl.NearCacheStatsImpl;
import com.hazelcast.util.Clock;
import com.hazelcast.util.JsonUtil;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class LocalMapStatsImpl
implements LocalMapStats {
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> LAST_ACCESS_TIME = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "lastAccessTime");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> LAST_UPDATE_TIME = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "lastUpdateTime");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> NUMBER_OF_OTHER_OPERATIONS = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "numberOfOtherOperations");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> NUMBER_OF_EVENTS = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "numberOfEvents");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> GET_COUNT = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "getCount");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> PUT_COUNT = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "putCount");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> REMOVE_COUNT = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "removeCount");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> TOTAL_GET_LATENCIES = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "totalGetLatencies");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> TOTAL_PUT_LATENCIES = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "totalPutLatencies");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> TOTAL_REMOVE_LATENCIES = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "totalRemoveLatencies");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> MAX_GET_LATENCY = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "maxGetLatency");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> MAX_PUT_LATENCY = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "maxPutLatency");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> MAX_REMOVE_LATENCY = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "maxRemoveLatency");
    private volatile long lastAccessTime;
    private volatile long lastUpdateTime;
    private volatile long hits;
    private volatile long numberOfOtherOperations;
    private volatile long numberOfEvents;
    private volatile long getCount;
    private volatile long putCount;
    private volatile long removeCount;
    private volatile long totalGetLatencies;
    private volatile long totalPutLatencies;
    private volatile long totalRemoveLatencies;
    private volatile long maxGetLatency;
    private volatile long maxPutLatency;
    private volatile long maxRemoveLatency;
    private volatile long creationTime = Clock.currentTimeMillis();
    private volatile long ownedEntryCount;
    private volatile long backupEntryCount;
    private volatile long ownedEntryMemoryCost;
    private volatile long backupEntryMemoryCost;
    private volatile long heapCost;
    private volatile long lockedEntryCount;
    private volatile long dirtyEntryCount;
    private volatile int backupCount;
    private volatile NearCacheStats nearCacheStats;

    @Override
    public long getOwnedEntryCount() {
        return this.ownedEntryCount;
    }

    public void setOwnedEntryCount(long ownedEntryCount) {
        this.ownedEntryCount = ownedEntryCount;
    }

    @Override
    public long getBackupEntryCount() {
        return this.backupEntryCount;
    }

    public void setBackupEntryCount(long backupEntryCount) {
        this.backupEntryCount = backupEntryCount;
    }

    @Override
    public int getBackupCount() {
        return this.backupCount;
    }

    public void setBackupCount(int backupCount) {
        this.backupCount = backupCount;
    }

    @Override
    public long getOwnedEntryMemoryCost() {
        return this.ownedEntryMemoryCost;
    }

    public void setOwnedEntryMemoryCost(long ownedEntryMemoryCost) {
        this.ownedEntryMemoryCost = ownedEntryMemoryCost;
    }

    @Override
    public long getBackupEntryMemoryCost() {
        return this.backupEntryMemoryCost;
    }

    public void setBackupEntryMemoryCost(long backupEntryMemoryCost) {
        this.backupEntryMemoryCost = backupEntryMemoryCost;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(long lastAccessTime) {
        LAST_ACCESS_TIME.set(this, Math.max(this.lastAccessTime, lastAccessTime));
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        LAST_UPDATE_TIME.set(this, Math.max(this.lastUpdateTime, lastUpdateTime));
    }

    @Override
    public long getHits() {
        return this.hits;
    }

    public void setHits(long hits) {
        this.hits = hits;
    }

    @Override
    public long getLockedEntryCount() {
        return this.lockedEntryCount;
    }

    public void setLockedEntryCount(long lockedEntryCount) {
        this.lockedEntryCount = lockedEntryCount;
    }

    @Override
    public long getDirtyEntryCount() {
        return this.dirtyEntryCount;
    }

    public void setDirtyEntryCount(long dirtyEntryCount) {
        this.dirtyEntryCount = dirtyEntryCount;
    }

    @Override
    public long total() {
        return this.putCount + this.getCount + this.removeCount + this.numberOfOtherOperations;
    }

    @Override
    public long getPutOperationCount() {
        return this.putCount;
    }

    public void incrementPuts(long delta, long latency) {
        PUT_COUNT.addAndGet(this, delta);
        TOTAL_PUT_LATENCIES.addAndGet(this, latency);
        MAX_PUT_LATENCY.set(this, Math.max(this.maxPutLatency, latency / delta));
    }

    public void incrementPuts(long latency) {
        PUT_COUNT.incrementAndGet(this);
        TOTAL_PUT_LATENCIES.addAndGet(this, latency);
        MAX_PUT_LATENCY.set(this, Math.max(this.maxPutLatency, latency));
    }

    @Override
    public long getGetOperationCount() {
        return this.getCount;
    }

    public void incrementGets(long latency) {
        GET_COUNT.incrementAndGet(this);
        TOTAL_GET_LATENCIES.addAndGet(this, latency);
        MAX_GET_LATENCY.set(this, Math.max(this.maxGetLatency, latency));
    }

    @Override
    public long getRemoveOperationCount() {
        return this.removeCount;
    }

    public void incrementRemoves(long latency) {
        REMOVE_COUNT.incrementAndGet(this);
        TOTAL_REMOVE_LATENCIES.addAndGet(this, latency);
        MAX_REMOVE_LATENCY.set(this, Math.max(this.maxRemoveLatency, latency));
    }

    @Override
    public long getTotalPutLatency() {
        return this.totalPutLatencies;
    }

    @Override
    public long getTotalGetLatency() {
        return this.totalGetLatencies;
    }

    @Override
    public long getTotalRemoveLatency() {
        return this.totalRemoveLatencies;
    }

    @Override
    public long getMaxPutLatency() {
        return this.maxPutLatency;
    }

    @Override
    public long getMaxGetLatency() {
        return this.maxGetLatency;
    }

    @Override
    public long getMaxRemoveLatency() {
        return this.maxRemoveLatency;
    }

    @Override
    public long getOtherOperationCount() {
        return this.numberOfOtherOperations;
    }

    public void incrementOtherOperations() {
        NUMBER_OF_OTHER_OPERATIONS.incrementAndGet(this);
    }

    @Override
    public long getEventOperationCount() {
        return this.numberOfEvents;
    }

    public void incrementReceivedEvents() {
        NUMBER_OF_EVENTS.incrementAndGet(this);
    }

    @Override
    public long getHeapCost() {
        return this.heapCost;
    }

    public void setHeapCost(long heapCost) {
        this.heapCost = heapCost;
    }

    @Override
    public NearCacheStats getNearCacheStats() {
        return this.nearCacheStats;
    }

    public void setNearCacheStats(NearCacheStats nearCacheStats) {
        this.nearCacheStats = nearCacheStats;
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("getCount", this.getCount);
        root.add("putCount", this.putCount);
        root.add("removeCount", this.removeCount);
        root.add("numberOfOtherOperations", this.numberOfOtherOperations);
        root.add("numberOfEvents", this.numberOfEvents);
        root.add("lastAccessTime", this.lastAccessTime);
        root.add("lastUpdateTime", this.lastUpdateTime);
        root.add("hits", this.hits);
        root.add("ownedEntryCount", this.ownedEntryCount);
        root.add("backupEntryCount", this.backupEntryCount);
        root.add("backupCount", this.backupCount);
        root.add("ownedEntryMemoryCost", this.ownedEntryMemoryCost);
        root.add("backupEntryMemoryCost", this.backupEntryMemoryCost);
        root.add("creationTime", this.creationTime);
        root.add("lockedEntryCount", this.lockedEntryCount);
        root.add("dirtyEntryCount", this.dirtyEntryCount);
        root.add("totalGetLatencies", this.totalGetLatencies);
        root.add("totalPutLatencies", this.totalPutLatencies);
        root.add("totalRemoveLatencies", this.totalRemoveLatencies);
        root.add("maxGetLatency", this.maxGetLatency);
        root.add("maxPutLatency", this.maxPutLatency);
        root.add("maxRemoveLatency", this.maxRemoveLatency);
        root.add("heapCost", this.heapCost);
        if (this.nearCacheStats != null) {
            root.add("nearCacheStats", this.nearCacheStats.toJson());
        }
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.getCount = JsonUtil.getLong(json, "getCount", -1L);
        this.putCount = JsonUtil.getLong(json, "putCount", -1L);
        this.removeCount = JsonUtil.getLong(json, "removeCount", -1L);
        this.numberOfOtherOperations = JsonUtil.getLong(json, "numberOfOtherOperations", -1L);
        this.numberOfEvents = JsonUtil.getLong(json, "numberOfEvents", -1L);
        this.lastAccessTime = JsonUtil.getLong(json, "lastAccessTime", -1L);
        this.lastUpdateTime = JsonUtil.getLong(json, "lastUpdateTime", -1L);
        this.totalGetLatencies = JsonUtil.getLong(json, "totalGetLatencies", -1L);
        this.totalPutLatencies = JsonUtil.getLong(json, "totalPutLatencies", -1L);
        this.totalRemoveLatencies = JsonUtil.getLong(json, "totalRemoveLatencies", -1L);
        this.maxGetLatency = JsonUtil.getLong(json, "maxGetLatency", -1L);
        this.maxPutLatency = JsonUtil.getLong(json, "maxPutLatency", -1L);
        this.maxRemoveLatency = JsonUtil.getLong(json, "maxRemoveLatency", -1L);
        this.hits = JsonUtil.getLong(json, "hits", -1L);
        this.ownedEntryCount = JsonUtil.getLong(json, "ownedEntryCount", -1L);
        this.backupEntryCount = JsonUtil.getLong(json, "backupEntryCount", -1L);
        this.backupCount = JsonUtil.getInt(json, "backupCount", -1);
        this.ownedEntryMemoryCost = JsonUtil.getLong(json, "ownedEntryMemoryCost", -1L);
        this.backupEntryMemoryCost = JsonUtil.getLong(json, "backupEntryMemoryCost", -1L);
        this.creationTime = JsonUtil.getLong(json, "creationTime", -1L);
        this.lockedEntryCount = JsonUtil.getLong(json, "lockedEntryCount", -1L);
        this.dirtyEntryCount = JsonUtil.getLong(json, "dirtyEntryCount", -1L);
        this.heapCost = JsonUtil.getLong(json, "heapCost", -1L);
        JsonValue jsonNearCacheStats = json.get("nearCacheStats");
        if (jsonNearCacheStats != null) {
            this.nearCacheStats = new NearCacheStatsImpl();
            this.nearCacheStats.fromJson(jsonNearCacheStats.asObject());
        }
    }

    public String toString() {
        return "LocalMapStatsImpl{lastAccessTime=" + this.lastAccessTime + ", lastUpdateTime=" + this.lastUpdateTime + ", hits=" + this.hits + ", numberOfOtherOperations=" + this.numberOfOtherOperations + ", numberOfEvents=" + this.numberOfEvents + ", getCount=" + this.getCount + ", putCount=" + this.putCount + ", removeCount=" + this.removeCount + ", totalGetLatencies=" + this.totalGetLatencies + ", totalPutLatencies=" + this.totalPutLatencies + ", totalRemoveLatencies=" + this.totalRemoveLatencies + ", ownedEntryCount=" + this.ownedEntryCount + ", backupEntryCount=" + this.backupEntryCount + ", backupCount=" + this.backupCount + ", ownedEntryMemoryCost=" + this.ownedEntryMemoryCost + ", backupEntryMemoryCost=" + this.backupEntryMemoryCost + ", creationTime=" + this.creationTime + ", lockedEntryCount=" + this.lockedEntryCount + ", dirtyEntryCount=" + this.dirtyEntryCount + ", heapCost=" + this.heapCost + '}';
    }
}

