/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster.impl.operations;

import com.hazelcast.cluster.impl.ClusterServiceImpl;
import com.hazelcast.cluster.impl.operations.AbstractClusterOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import java.io.IOException;

public class MemberRemoveOperation
extends AbstractClusterOperation
implements AllowedDuringPassiveState {
    private Address deadAddress;

    public MemberRemoveOperation() {
    }

    public MemberRemoveOperation(Address deadAddress) {
        this.deadAddress = deadAddress;
    }

    @Override
    public void run() {
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
        Address caller = this.getCallerAddress();
        ILogger logger = this.getLogger();
        if (caller != null && (caller.equals(this.deadAddress) || caller.equals(clusterService.getMasterAddress()))) {
            if (logger.isFinestEnabled()) {
                logger.finest("Removing " + this.deadAddress + ", called from " + caller);
            }
            clusterService.removeAddress(this.deadAddress);
        } else if (logger.isFinestEnabled()) {
            logger.finest("Ignoring removal request of " + this.deadAddress + ", because sender is neither dead-member " + "nor master, called from " + caller);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.deadAddress = new Address();
        this.deadAddress.readData(in);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        this.deadAddress.writeData(out);
    }
}

