/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.cluster.ClusterService;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.GroupProperties;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.internal.management.ManagementCenterService;
import com.hazelcast.internal.storage.DataRef;
import com.hazelcast.internal.storage.Storage;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.partition.MigrationInfo;
import com.hazelcast.quorum.impl.QuorumServiceImpl;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PostJoinAwareService;
import com.hazelcast.spi.ServiceInfo;
import com.hazelcast.spi.SharedService;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.impl.ServiceManager;
import com.hazelcast.spi.impl.eventservice.InternalEventService;
import com.hazelcast.spi.impl.eventservice.impl.EventServiceImpl;
import com.hazelcast.spi.impl.eventservice.impl.operations.PostJoinRegistrationOperation;
import com.hazelcast.spi.impl.executionservice.InternalExecutionService;
import com.hazelcast.spi.impl.executionservice.impl.ExecutionServiceImpl;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.impl.proxyservice.InternalProxyService;
import com.hazelcast.spi.impl.proxyservice.impl.ProxyServiceImpl;
import com.hazelcast.spi.impl.transceiver.PacketTransceiver;
import com.hazelcast.spi.impl.transceiver.impl.PacketTransceiverImpl;
import com.hazelcast.spi.impl.waitnotifyservice.InternalWaitNotifyService;
import com.hazelcast.spi.impl.waitnotifyservice.impl.WaitNotifyServiceImpl;
import com.hazelcast.transaction.TransactionManagerService;
import com.hazelcast.transaction.impl.TransactionManagerServiceImpl;
import com.hazelcast.wan.WanReplicationService;
import java.util.Collection;
import java.util.LinkedList;

public class NodeEngineImpl
implements NodeEngine {
    private final Node node;
    private final ILogger logger;
    private final EventServiceImpl eventService;
    private final OperationServiceImpl operationService;
    private final ExecutionServiceImpl executionService;
    private final WaitNotifyServiceImpl waitNotifyService;
    private final ServiceManager serviceManager;
    private final TransactionManagerServiceImpl transactionManagerService;
    private final ProxyServiceImpl proxyService;
    private final WanReplicationService wanReplicationService;
    private final PacketTransceiver packetTransceiver;
    private final QuorumServiceImpl quorumService;

    public NodeEngineImpl(Node node) {
        this.node = node;
        this.logger = node.getLogger(NodeEngine.class.getName());
        this.proxyService = new ProxyServiceImpl(this);
        this.serviceManager = new ServiceManager(this);
        this.executionService = new ExecutionServiceImpl(this);
        this.operationService = new OperationServiceImpl(this);
        this.eventService = new EventServiceImpl(this);
        this.waitNotifyService = new WaitNotifyServiceImpl(this);
        this.transactionManagerService = new TransactionManagerServiceImpl(this);
        this.wanReplicationService = node.getNodeExtension().createService(WanReplicationService.class);
        this.packetTransceiver = new PacketTransceiverImpl(node, this.logger, this.operationService, this.eventService, this.wanReplicationService, this.executionService);
        this.quorumService = new QuorumServiceImpl(this);
    }

    public PacketTransceiver getPacketTransceiver() {
        return this.packetTransceiver;
    }

    public void start() {
        this.serviceManager.start();
        this.proxyService.init();
        this.quorumService.start();
    }

    @Override
    public Address getThisAddress() {
        return this.node.getThisAddress();
    }

    @Override
    public Address getMasterAddress() {
        return this.node.getMasterAddress();
    }

    @Override
    public MemberImpl getLocalMember() {
        return this.node.getLocalMember();
    }

    @Override
    public Config getConfig() {
        return this.node.getConfig();
    }

    @Override
    public ClassLoader getConfigClassLoader() {
        return this.node.getConfigClassLoader();
    }

    @Override
    public InternalEventService getEventService() {
        return this.eventService;
    }

    @Override
    public SerializationService getSerializationService() {
        return this.node.getSerializationService();
    }

    @Override
    public InternalOperationService getOperationService() {
        return this.operationService;
    }

    @Override
    public InternalExecutionService getExecutionService() {
        return this.executionService;
    }

    @Override
    public InternalPartitionService getPartitionService() {
        return this.node.getPartitionService();
    }

    @Override
    public ClusterService getClusterService() {
        return this.node.getClusterService();
    }

    public ManagementCenterService getManagementCenterService() {
        return this.node.getManagementCenterService();
    }

    @Override
    public InternalProxyService getProxyService() {
        return this.proxyService;
    }

    @Override
    public InternalWaitNotifyService getWaitNotifyService() {
        return this.waitNotifyService;
    }

    @Override
    public WanReplicationService getWanReplicationService() {
        return this.wanReplicationService;
    }

    @Override
    public QuorumServiceImpl getQuorumService() {
        return this.quorumService;
    }

    @Override
    public TransactionManagerService getTransactionManagerService() {
        return this.transactionManagerService;
    }

    @Override
    public Data toData(Object object) {
        return this.node.getSerializationService().toData(object);
    }

    public Object toObject(Object object) {
        if (object instanceof Data) {
            return this.node.getSerializationService().toObject(object);
        }
        return object;
    }

    @Override
    public boolean isActive() {
        return this.node.isActive();
    }

    @Override
    public HazelcastInstance getHazelcastInstance() {
        return this.node.hazelcastInstance;
    }

    @Override
    public ILogger getLogger(String name) {
        return this.node.getLogger(name);
    }

    @Override
    public ILogger getLogger(Class clazz) {
        return this.node.getLogger(clazz);
    }

    @Override
    public GroupProperties getGroupProperties() {
        return this.node.getGroupProperties();
    }

    public <T> T getService(String serviceName) {
        Object service;
        ServiceInfo serviceInfo = this.serviceManager.getServiceInfo(serviceName);
        Object object = service = serviceInfo != null ? serviceInfo.getService() : null;
        if (service == null) {
            if (!this.isActive()) {
                throw new HazelcastException("Service with name '" + serviceName + "' not found!");
            }
            throw new RetryableHazelcastException("HazelcastInstance[" + this.getThisAddress() + "] is not active!");
        }
        return (T)service;
    }

    @Override
    public <T extends SharedService> T getSharedService(String serviceName) {
        Object service;
        ServiceInfo serviceInfo = this.serviceManager.getServiceInfo(serviceName);
        Object object = service = serviceInfo != null ? serviceInfo.getService() : null;
        if (service == null) {
            return null;
        }
        if (service instanceof SharedService) {
            return (T)((SharedService)service);
        }
        throw new IllegalArgumentException("No SharedService registered with name: " + serviceName);
    }

    public <S> Collection<S> getServices(Class<S> serviceClass) {
        return this.serviceManager.getServices(serviceClass);
    }

    public Collection<ServiceInfo> getServiceInfos(Class serviceClass) {
        return this.serviceManager.getServiceInfos(serviceClass);
    }

    public Node getNode() {
        return this.node;
    }

    public void onMemberLeft(MemberImpl member) {
        this.waitNotifyService.onMemberLeft(member);
        this.operationService.onMemberLeft(member);
        this.eventService.onMemberLeft(member);
    }

    public void onClientDisconnected(String clientUuid) {
        this.waitNotifyService.onClientDisconnected(clientUuid);
    }

    public void onPartitionMigrate(MigrationInfo migrationInfo) {
        this.waitNotifyService.onPartitionMigrate(this.getThisAddress(), migrationInfo);
    }

    public Operation[] getPostJoinOperations() {
        LinkedList<Operation> postJoinOps = new LinkedList<Operation>();
        PostJoinRegistrationOperation eventPostJoinOp = this.eventService.getPostJoinOperation();
        if (eventPostJoinOp != null) {
            postJoinOps.add(eventPostJoinOp);
        }
        Collection<PostJoinAwareService> services = this.getServices(PostJoinAwareService.class);
        for (PostJoinAwareService service : services) {
            Operation postJoinOperation = service.getPostJoinOperation();
            if (postJoinOperation == null) continue;
            if (postJoinOperation.getPartitionId() >= 0) {
                this.logger.severe("Post-join operations cannot implement PartitionAwareOperation! Service: " + service + ", Operation: " + postJoinOperation);
                continue;
            }
            postJoinOps.add(postJoinOperation);
        }
        return postJoinOps.isEmpty() ? null : postJoinOps.toArray(new Operation[postJoinOps.size()]);
    }

    @Override
    public Storage<DataRef> getOffHeapStorage() {
        return this.node.getNodeExtension().getNativeDataStorage();
    }

    public void reset() {
        this.waitNotifyService.reset();
        this.operationService.reset();
    }

    public void shutdown(boolean terminate) {
        this.logger.finest("Shutting down services...");
        this.waitNotifyService.shutdown();
        this.proxyService.shutdown();
        this.serviceManager.shutdown(terminate);
        this.eventService.shutdown();
        this.operationService.shutdown();
        this.wanReplicationService.shutdown();
        this.executionService.shutdown();
    }
}

