/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.MapEvent;
import com.hazelcast.jmx.HazelcastMBean;
import com.hazelcast.jmx.ManagedAnnotation;
import com.hazelcast.jmx.ManagedDescription;
import com.hazelcast.jmx.ManagementService;
import com.hazelcast.replicatedmap.impl.ReplicatedMapProxy;
import com.hazelcast.util.EmptyStatement;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

@ManagedDescription(value="ReplicatedMap")
public class ReplicatedMapMBean
extends HazelcastMBean<ReplicatedMapProxy> {
    private final boolean totalEnabled;
    private final AtomicLong totalAddedEntryCount = new AtomicLong();
    private final AtomicLong totalRemovedEntryCount = new AtomicLong();
    private final AtomicLong totalUpdatedEntryCount = new AtomicLong();
    private final String listenerId;

    protected ReplicatedMapMBean(ReplicatedMapProxy managedObject, ManagementService service) {
        super(managedObject, service);
        this.totalEnabled = service.instance.node.groupProperties.ENABLE_JMX_DETAILED.getBoolean();
        this.objectName = service.createObjectName("ReplicatedMap", managedObject.getName());
        if (this.totalEnabled) {
            EntryListener entryListener = new EntryListener(){

                @Override
                public void entryAdded(EntryEvent event) {
                    ReplicatedMapMBean.this.totalAddedEntryCount.incrementAndGet();
                }

                @Override
                public void entryRemoved(EntryEvent event) {
                    ReplicatedMapMBean.this.totalRemovedEntryCount.incrementAndGet();
                }

                @Override
                public void entryUpdated(EntryEvent event) {
                    ReplicatedMapMBean.this.totalUpdatedEntryCount.incrementAndGet();
                }

                @Override
                public void entryEvicted(EntryEvent event) {
                }

                @Override
                public void mapEvicted(MapEvent event) {
                }

                @Override
                public void mapCleared(MapEvent event) {
                }
            };
            this.listenerId = managedObject.addEntryListener(entryListener, false);
        } else {
            this.listenerId = null;
        }
    }

    @Override
    public void preDeregister() throws Exception {
        super.preDeregister();
        if (this.totalEnabled) {
            try {
                ((ReplicatedMapProxy)this.managedObject).removeEntryListener(this.listenerId);
            }
            catch (Exception ignored) {
                EmptyStatement.ignore(ignored);
            }
        }
    }

    @ManagedAnnotation(value="localOwnedEntryCount")
    @ManagedDescription(value="number of entries owned on this member")
    public long getLocalOwnedEntryCount() {
        return ((ReplicatedMapProxy)this.managedObject).getReplicatedMapStats().getOwnedEntryCount();
    }

    @ManagedAnnotation(value="localCreationTime")
    @ManagedDescription(value="the creation time of this map on this member.")
    public long getLocalCreationTime() {
        return ((ReplicatedMapProxy)this.managedObject).getReplicatedMapStats().getCreationTime();
    }

    @ManagedAnnotation(value="localLastAccessTime")
    @ManagedDescription(value="the last access (read) time of the locally owned entries.")
    public long getLocalLastAccessTime() {
        return ((ReplicatedMapProxy)this.managedObject).getReplicatedMapStats().getLastAccessTime();
    }

    @ManagedAnnotation(value="localLastUpdateTime")
    @ManagedDescription(value="the last update time of the locally owned entries.")
    public long getLocalLastUpdateTime() {
        return ((ReplicatedMapProxy)this.managedObject).getReplicatedMapStats().getLastUpdateTime();
    }

    @ManagedAnnotation(value="localHits")
    @ManagedDescription(value="the number of hits (reads) of the locally owned entries.")
    public long getLocalHits() {
        return ((ReplicatedMapProxy)this.managedObject).getReplicatedMapStats().getHits();
    }

    @ManagedAnnotation(value="localPutOperationCount")
    @ManagedDescription(value="the number of put operations on this member")
    public long getLocalPutOperationCount() {
        return ((ReplicatedMapProxy)this.managedObject).getReplicatedMapStats().getPutOperationCount();
    }

    @ManagedAnnotation(value="localGetOperationCount")
    @ManagedDescription(value="number of get operations on this member")
    public long getLocalGetOperationCount() {
        return ((ReplicatedMapProxy)this.managedObject).getReplicatedMapStats().getGetOperationCount();
    }

    @ManagedAnnotation(value="localRemoveOperationCount")
    @ManagedDescription(value="number of remove operations on this member")
    public long getLocalRemoveOperationCount() {
        return ((ReplicatedMapProxy)this.managedObject).getReplicatedMapStats().getRemoveOperationCount();
    }

    @ManagedAnnotation(value="localTotalPutLatency")
    @ManagedDescription(value="the total latency of put operations. To get the average latency, divide to number of puts")
    public long getLocalTotalPutLatency() {
        return ((ReplicatedMapProxy)this.managedObject).getReplicatedMapStats().getTotalPutLatency();
    }

    @ManagedAnnotation(value="localTotalGetLatency")
    @ManagedDescription(value="the total latency of get operations. To get the average latency, divide to number of gets")
    public long getLocalTotalGetLatency() {
        return ((ReplicatedMapProxy)this.managedObject).getReplicatedMapStats().getTotalGetLatency();
    }

    @ManagedAnnotation(value="localTotalRemoveLatency")
    @ManagedDescription(value="the total latency of remove operations. To get the average latency, divide to number of gets")
    public long getLocalTotalRemoveLatency() {
        return ((ReplicatedMapProxy)this.managedObject).getReplicatedMapStats().getTotalRemoveLatency();
    }

    @ManagedAnnotation(value="localMaxPutLatency")
    @ManagedDescription(value="the maximum latency of put operations. To get the average latency, divide to number of puts")
    public long getLocalMaxPutLatency() {
        return ((ReplicatedMapProxy)this.managedObject).getReplicatedMapStats().getMaxPutLatency();
    }

    @ManagedAnnotation(value="localMaxGetLatency")
    @ManagedDescription(value="the maximum latency of get operations. To get the average latency, divide to number of gets")
    public long getLocalMaxGetLatency() {
        return ((ReplicatedMapProxy)this.managedObject).getReplicatedMapStats().getMaxGetLatency();
    }

    @ManagedAnnotation(value="localMaxRemoveLatency")
    @ManagedDescription(value="the maximum latency of remove operations. To get the average latency, divide to number of gets")
    public long getMaxRemoveLatency() {
        return ((ReplicatedMapProxy)this.managedObject).getReplicatedMapStats().getMaxRemoveLatency();
    }

    @ManagedAnnotation(value="localEventOperationCount")
    @ManagedDescription(value="number of events received on this member")
    public long getLocalEventOperationCount() {
        return ((ReplicatedMapProxy)this.managedObject).getReplicatedMapStats().getEventOperationCount();
    }

    @ManagedAnnotation(value="localReplicationEventCount")
    @ManagedDescription(value="number of replication events received on this member")
    public long getLocalReplicationEventCount() {
        return ((ReplicatedMapProxy)this.managedObject).getReplicatedMapStats().getReplicationEventCount();
    }

    @ManagedAnnotation(value="localOtherOperationCount")
    @ManagedDescription(value="the total number of other operations on this member")
    public long getLocalOtherOperationCount() {
        return ((ReplicatedMapProxy)this.managedObject).getReplicatedMapStats().getOtherOperationCount();
    }

    @ManagedAnnotation(value="localTotal")
    @ManagedDescription(value="the total number of operations on this member")
    public long localTotal() {
        return ((ReplicatedMapProxy)this.managedObject).getReplicatedMapStats().total();
    }

    @ManagedAnnotation(value="name")
    @ManagedDescription(value="name of the map")
    public String getName() {
        return ((ReplicatedMapProxy)this.managedObject).getName();
    }

    @ManagedAnnotation(value="size")
    @ManagedDescription(value="size of the map")
    public int getSize() {
        return ((ReplicatedMapProxy)this.managedObject).size();
    }

    @ManagedAnnotation(value="config")
    @ManagedDescription(value="MapConfig")
    public String getConfig() {
        return this.service.instance.getConfig().findMapConfig(((ReplicatedMapProxy)this.managedObject).getName()).toString();
    }

    @ManagedAnnotation(value="totalAddedEntryCount")
    public long getTotalAddedEntryCount() {
        return this.totalAddedEntryCount.get();
    }

    @ManagedAnnotation(value="totalRemovedEntryCount")
    public long getTotalRemovedEntryCount() {
        return this.totalRemovedEntryCount.get();
    }

    @ManagedAnnotation(value="totalUpdatedEntryCount")
    public long getTotalUpdatedEntryCount() {
        return this.totalUpdatedEntryCount.get();
    }

    @ManagedAnnotation(value="clear", operation=true)
    @ManagedDescription(value="Clear Map")
    public void clear() {
        ((ReplicatedMapProxy)this.managedObject).clear();
    }

    @ManagedAnnotation(value="values", operation=true)
    public String values() {
        Collection coll = ((ReplicatedMapProxy)this.managedObject).values();
        StringBuilder buf = new StringBuilder();
        if (coll.size() == 0) {
            buf.append("Empty");
        } else {
            buf.append("[");
            for (Object obj : coll) {
                buf.append(obj);
                buf.append(", ");
            }
            buf.replace(buf.length() - 1, buf.length(), "]");
        }
        return buf.toString();
    }

    @ManagedAnnotation(value="entrySet", operation=true)
    public String entrySet() {
        Set entrySet = ((ReplicatedMapProxy)this.managedObject).entrySet();
        StringBuilder buf = new StringBuilder();
        if (entrySet.size() == 0) {
            buf.append("Empty");
        } else {
            buf.append("[");
            for (Map.Entry entry : entrySet) {
                buf.append("{key:");
                buf.append(entry.getKey());
                buf.append(", value:");
                buf.append(entry.getValue());
                buf.append("}, ");
            }
            buf.replace(buf.length() - 1, buf.length(), "]");
        }
        return buf.toString();
    }
}

