/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.tx;

import com.hazelcast.core.TransactionalMap;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.tx.TransactionalMapProxySupport;
import com.hazelcast.map.impl.tx.TxnValueWrapper;
import com.hazelcast.map.impl.tx.VersionedValue;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.QueryEntry;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.transaction.impl.TransactionSupport;
import com.hazelcast.util.IterationType;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.QueryResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class TransactionalMapProxy
extends TransactionalMapProxySupport
implements TransactionalMap {
    private final Map<Data, TxnValueWrapper> txMap = new HashMap<Data, TxnValueWrapper>();

    public TransactionalMapProxy(String name, MapService mapService, NodeEngine nodeEngine, TransactionSupport transaction) {
        super(name, mapService, nodeEngine, transaction);
    }

    @Override
    public boolean containsKey(Object key) {
        this.checkTransactionState();
        Data keyData = ((MapService)this.getService()).getMapServiceContext().toData(key, this.partitionStrategy);
        TxnValueWrapper valueWrapper = this.txMap.get(keyData);
        if (valueWrapper != null) {
            return valueWrapper.type != TxnValueWrapper.Type.REMOVED;
        }
        return this.containsKeyInternal(keyData);
    }

    @Override
    public int size() {
        this.checkTransactionState();
        int currentSize = this.sizeInternal();
        for (Map.Entry<Data, TxnValueWrapper> entry : this.txMap.entrySet()) {
            VersionedValue versionedValue;
            TxnValueWrapper wrapper = entry.getValue();
            if (wrapper.type == TxnValueWrapper.Type.NEW) {
                ++currentSize;
                continue;
            }
            if (wrapper.type != TxnValueWrapper.Type.REMOVED || (versionedValue = (VersionedValue)this.valueMap.get(entry.getKey())) == null || versionedValue.value == null) continue;
            --currentSize;
        }
        return currentSize;
    }

    @Override
    public boolean isEmpty() {
        this.checkTransactionState();
        return this.size() == 0;
    }

    @Override
    public Object get(Object key) {
        this.checkTransactionState();
        MapService service = (MapService)this.getService();
        MapServiceContext mapServiceContext = service.getMapServiceContext();
        Data keyData = mapServiceContext.toData(key, this.partitionStrategy);
        TxnValueWrapper currentValue = this.txMap.get(keyData);
        if (currentValue != null) {
            return this.checkIfRemoved(currentValue);
        }
        return mapServiceContext.toObject(this.getInternal(keyData));
    }

    public Object getForUpdate(Object key) {
        this.checkTransactionState();
        MapService service = (MapService)this.getService();
        MapServiceContext mapServiceContext = service.getMapServiceContext();
        Data keyData = mapServiceContext.toData(key, this.partitionStrategy);
        TxnValueWrapper currentValue = this.txMap.get(keyData);
        if (currentValue != null) {
            return this.checkIfRemoved(currentValue);
        }
        return mapServiceContext.toObject(this.getForUpdateInternal(keyData));
    }

    @Override
    public Object put(Object key, Object value) {
        this.checkTransactionState();
        MapService service = (MapService)this.getService();
        MapServiceContext mapServiceContext = service.getMapServiceContext();
        Data keyData = mapServiceContext.toData(key, this.partitionStrategy);
        Object valueBeforeTxn = mapServiceContext.toObject(this.putInternal(keyData, mapServiceContext.toData(value)));
        TxnValueWrapper currentValue = this.txMap.get(keyData);
        if (value != null) {
            TxnValueWrapper wrapper = valueBeforeTxn == null ? new TxnValueWrapper(value, TxnValueWrapper.Type.NEW) : new TxnValueWrapper(value, TxnValueWrapper.Type.UPDATED);
            this.txMap.put(keyData, wrapper);
        }
        return currentValue == null ? valueBeforeTxn : this.checkIfRemoved(currentValue);
    }

    public Object put(Object key, Object value, long ttl, TimeUnit timeUnit) {
        this.checkTransactionState();
        MapService service = (MapService)this.getService();
        MapServiceContext mapServiceContext = service.getMapServiceContext();
        Data keyData = mapServiceContext.toData(key, this.partitionStrategy);
        Object valueBeforeTxn = mapServiceContext.toObject(this.putInternal(keyData, mapServiceContext.toData(value), ttl, timeUnit));
        TxnValueWrapper currentValue = this.txMap.get(keyData);
        if (value != null) {
            TxnValueWrapper wrapper = valueBeforeTxn == null ? new TxnValueWrapper(value, TxnValueWrapper.Type.NEW) : new TxnValueWrapper(value, TxnValueWrapper.Type.UPDATED);
            this.txMap.put(keyData, wrapper);
        }
        return currentValue == null ? valueBeforeTxn : this.checkIfRemoved(currentValue);
    }

    @Override
    public void set(Object key, Object value) {
        this.checkTransactionState();
        MapService service = (MapService)this.getService();
        MapServiceContext mapServiceContext = service.getMapServiceContext();
        Data keyData = mapServiceContext.toData(key, this.partitionStrategy);
        Data dataBeforeTxn = this.putInternal(keyData, mapServiceContext.toData(value));
        if (value != null) {
            TxnValueWrapper wrapper = dataBeforeTxn == null ? new TxnValueWrapper(value, TxnValueWrapper.Type.NEW) : new TxnValueWrapper(value, TxnValueWrapper.Type.UPDATED);
            this.txMap.put(keyData, wrapper);
        }
    }

    @Override
    public Object putIfAbsent(Object key, Object value) {
        boolean haveTxnPast;
        this.checkTransactionState();
        MapService service = (MapService)this.getService();
        MapServiceContext mapServiceContext = service.getMapServiceContext();
        Data keyData = mapServiceContext.toData(key, this.partitionStrategy);
        TxnValueWrapper wrapper = this.txMap.get(keyData);
        boolean bl = haveTxnPast = wrapper != null;
        if (haveTxnPast) {
            if (wrapper.type != TxnValueWrapper.Type.REMOVED) {
                return wrapper.value;
            }
            this.putInternal(keyData, mapServiceContext.toData(value));
            this.txMap.put(keyData, new TxnValueWrapper(value, TxnValueWrapper.Type.NEW));
            return null;
        }
        Data oldValue = this.putIfAbsentInternal(keyData, mapServiceContext.toData(value));
        if (oldValue == null) {
            this.txMap.put(keyData, new TxnValueWrapper(value, TxnValueWrapper.Type.NEW));
        }
        return mapServiceContext.toObject(oldValue);
    }

    @Override
    public Object replace(Object key, Object value) {
        boolean haveTxnPast;
        this.checkTransactionState();
        MapService service = (MapService)this.getService();
        MapServiceContext mapServiceContext = service.getMapServiceContext();
        Data keyData = mapServiceContext.toData(key, this.partitionStrategy);
        TxnValueWrapper wrapper = this.txMap.get(keyData);
        boolean bl = haveTxnPast = wrapper != null;
        if (haveTxnPast) {
            if (wrapper.type == TxnValueWrapper.Type.REMOVED) {
                return null;
            }
            this.putInternal(keyData, mapServiceContext.toData(value));
            this.txMap.put(keyData, new TxnValueWrapper(value, TxnValueWrapper.Type.UPDATED));
            return wrapper.value;
        }
        Data oldValue = this.replaceInternal(keyData, mapServiceContext.toData(value));
        if (oldValue != null) {
            this.txMap.put(keyData, new TxnValueWrapper(value, TxnValueWrapper.Type.UPDATED));
        }
        return mapServiceContext.toObject(oldValue);
    }

    @Override
    public boolean replace(Object key, Object oldValue, Object newValue) {
        boolean haveTxnPast;
        this.checkTransactionState();
        MapService service = (MapService)this.getService();
        MapServiceContext mapServiceContext = service.getMapServiceContext();
        Data keyData = mapServiceContext.toData(key, this.partitionStrategy);
        TxnValueWrapper wrapper = this.txMap.get(keyData);
        boolean bl = haveTxnPast = wrapper != null;
        if (haveTxnPast) {
            if (!wrapper.value.equals(oldValue)) {
                return false;
            }
            this.putInternal(keyData, mapServiceContext.toData(newValue));
            this.txMap.put(keyData, new TxnValueWrapper(wrapper.value, TxnValueWrapper.Type.UPDATED));
            return true;
        }
        boolean success = this.replaceIfSameInternal(keyData, mapServiceContext.toData(oldValue), mapServiceContext.toData(newValue));
        if (success) {
            this.txMap.put(keyData, new TxnValueWrapper(newValue, TxnValueWrapper.Type.UPDATED));
        }
        return success;
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.checkTransactionState();
        MapService service = (MapService)this.getService();
        MapServiceContext mapServiceContext = service.getMapServiceContext();
        Data keyData = mapServiceContext.toData(key, this.partitionStrategy);
        TxnValueWrapper wrapper = this.txMap.get(keyData);
        if (wrapper != null && !mapServiceContext.compare(this.name, wrapper.value, value)) {
            return false;
        }
        boolean removed = this.removeIfSameInternal(keyData, value);
        if (removed) {
            this.txMap.put(keyData, new TxnValueWrapper(value, TxnValueWrapper.Type.REMOVED));
        }
        return removed;
    }

    @Override
    public Object remove(Object key) {
        this.checkTransactionState();
        MapService service = (MapService)this.getService();
        MapServiceContext mapServiceContext = service.getMapServiceContext();
        Data keyData = mapServiceContext.toData(key, this.partitionStrategy);
        Object valueBeforeTxn = mapServiceContext.toObject(this.removeInternal(keyData));
        TxnValueWrapper wrapper = null;
        if (valueBeforeTxn != null || this.txMap.containsKey(keyData)) {
            wrapper = this.txMap.put(keyData, new TxnValueWrapper(valueBeforeTxn, TxnValueWrapper.Type.REMOVED));
        }
        return wrapper == null ? valueBeforeTxn : this.checkIfRemoved(wrapper);
    }

    @Override
    public void delete(Object key) {
        this.checkTransactionState();
        MapService service = (MapService)this.getService();
        MapServiceContext mapServiceContext = service.getMapServiceContext();
        Data keyData = mapServiceContext.toData(key, this.partitionStrategy);
        Data data = this.removeInternal(keyData);
        if (data != null || this.txMap.containsKey(keyData)) {
            this.txMap.put(keyData, new TxnValueWrapper(mapServiceContext.toObject(data), TxnValueWrapper.Type.REMOVED));
        }
    }

    public Set<Object> keySet() {
        this.checkTransactionState();
        Set<Data> keySet = this.keySetInternal();
        MapService service = (MapService)this.getService();
        MapServiceContext mapServiceContext = service.getMapServiceContext();
        for (Map.Entry<Data, TxnValueWrapper> entry : this.txMap.entrySet()) {
            if (TxnValueWrapper.Type.NEW.equals((Object)entry.getValue().type)) {
                keySet.add(entry.getKey());
                continue;
            }
            if (!TxnValueWrapper.Type.REMOVED.equals((Object)entry.getValue().type)) continue;
            keySet.remove(entry.getKey());
        }
        HashSet<Object> keys = new HashSet<Object>();
        for (Data keyData : keySet) {
            keys.add(mapServiceContext.toObject(keyData));
        }
        return keys;
    }

    public Set keySet(Predicate predicate) {
        this.checkTransactionState();
        Preconditions.checkNotNull(predicate, "Predicate should not be null!");
        Preconditions.checkNotInstanceOf(PagingPredicate.class, predicate, "Paging is not supported for Transactional queries!");
        MapService service = (MapService)this.getService();
        MapServiceContext mapServiceContext = service.getMapServiceContext();
        SerializationService ss = this.getNodeEngine().getSerializationService();
        QueryResultSet queryResultSet = (QueryResultSet)this.queryInternal(predicate, IterationType.KEY, false);
        HashSet keySet = new HashSet(queryResultSet);
        for (Map.Entry<Data, TxnValueWrapper> entry : this.txMap.entrySet()) {
            Object key = ss.toObject(entry.getKey());
            if (!TxnValueWrapper.Type.REMOVED.equals((Object)entry.getValue().type)) {
                Object value;
                Object object = value = entry.getValue().value instanceof Data ? mapServiceContext.toObject(entry.getValue().value) : entry.getValue().value;
                QueryEntry queryEntry = new QueryEntry(ss, entry.getKey(), key, value);
                if (!predicate.apply(queryEntry)) continue;
                keySet.add(key);
                continue;
            }
            keySet.remove(key);
        }
        return keySet;
    }

    public Collection<Object> values() {
        this.checkTransactionState();
        List<Map.Entry<Data, Data>> entries = this.getEntries();
        MapService service = (MapService)this.getService();
        MapServiceContext mapServiceContext = service.getMapServiceContext();
        ArrayList<Object> values = new ArrayList<Object>(entries.size());
        HashSet<Data> keyWontBeIncluded = new HashSet<Data>();
        for (Map.Entry<Data, TxnValueWrapper> entry : this.txMap.entrySet()) {
            boolean isRemoved = TxnValueWrapper.Type.REMOVED.equals((Object)entry.getValue().type);
            boolean isUpdated = TxnValueWrapper.Type.UPDATED.equals((Object)entry.getValue().type);
            if (isRemoved) {
                keyWontBeIncluded.add(entry.getKey());
                continue;
            }
            if (isUpdated) {
                keyWontBeIncluded.add(entry.getKey());
            }
            Object entryValue = entry.getValue().value;
            values.add(entryValue);
        }
        for (Map.Entry<Data, Object> entry : entries) {
            if (keyWontBeIncluded.contains(entry.getKey())) continue;
            Object value = mapServiceContext.toObject(entry.getValue());
            values.add(value);
        }
        return values;
    }

    public Collection values(Predicate predicate) {
        this.checkTransactionState();
        Preconditions.checkNotNull(predicate, "Predicate can not be null!");
        Preconditions.checkNotInstanceOf(PagingPredicate.class, predicate, "Paging is not supported for Transactional queries");
        SerializationService serializationService = this.getNodeEngine().getSerializationService();
        QueryResultSet queryResultSet = (QueryResultSet)this.queryInternal(predicate, IterationType.ENTRY, false);
        ArrayList<Object> valueSet = new ArrayList<Object>();
        HashSet<Object> keyWontBeIncluded = new HashSet<Object>();
        for (Map.Entry<Data, TxnValueWrapper> entry : this.txMap.entrySet()) {
            boolean isRemoved = TxnValueWrapper.Type.REMOVED.equals((Object)entry.getValue().type);
            boolean isUpdated = TxnValueWrapper.Type.UPDATED.equals((Object)entry.getValue().type);
            Object keyObject = serializationService.toObject(entry.getKey());
            if (isRemoved) {
                keyWontBeIncluded.add(keyObject);
                continue;
            }
            if (isUpdated) {
                keyWontBeIncluded.add(keyObject);
            }
            Object entryValue = entry.getValue().value;
            QueryEntry queryEntry = new QueryEntry(serializationService, entry.getKey(), keyObject, entryValue);
            if (!predicate.apply(queryEntry)) continue;
            valueSet.add(queryEntry.getValue());
        }
        this.removeFromResultSet(queryResultSet, valueSet, keyWontBeIncluded);
        return valueSet;
    }

    @Override
    public String toString() {
        return "TransactionalMap{name='" + this.name + '\'' + '}';
    }

    private Object checkIfRemoved(TxnValueWrapper wrapper) {
        this.checkTransactionState();
        return wrapper == null || wrapper.type == TxnValueWrapper.Type.REMOVED ? null : wrapper.value;
    }

    private void removeFromResultSet(QueryResultSet queryResultSet, List<Object> valueSet, Set<Object> keyWontBeIncluded) {
        Iterator<Map.Entry> iterator = queryResultSet.rawIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (keyWontBeIncluded.contains(entry.getKey())) continue;
            valueSet.add(entry.getValue());
        }
    }
}

