/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.concurrent.atomicreference.client.AlterAndGetRequest;
import com.hazelcast.concurrent.atomicreference.client.AlterRequest;
import com.hazelcast.concurrent.atomicreference.client.ApplyRequest;
import com.hazelcast.concurrent.atomicreference.client.CompareAndSetRequest;
import com.hazelcast.concurrent.atomicreference.client.ContainsRequest;
import com.hazelcast.concurrent.atomicreference.client.GetAndAlterRequest;
import com.hazelcast.concurrent.atomicreference.client.GetAndSetRequest;
import com.hazelcast.concurrent.atomicreference.client.GetRequest;
import com.hazelcast.concurrent.atomicreference.client.IsNullRequest;
import com.hazelcast.concurrent.atomicreference.client.SetRequest;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.IFunction;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.Preconditions;

public class ClientAtomicReferenceProxy<E>
extends ClientProxy
implements IAtomicReference<E> {
    private final String name;
    private volatile Data key;

    public ClientAtomicReferenceProxy(String serviceName, String objectId) {
        super(serviceName, objectId);
        this.name = objectId;
    }

    @Override
    public <R> R apply(IFunction<E, R> function) {
        Preconditions.isNotNull(function, "function");
        return (R)this.invoke(new ApplyRequest(this.name, this.toData(function)));
    }

    @Override
    public void alter(IFunction<E, E> function) {
        Preconditions.isNotNull(function, "function");
        this.invoke(new AlterRequest(this.name, this.toData(function)));
    }

    @Override
    public E alterAndGet(IFunction<E, E> function) {
        Preconditions.isNotNull(function, "function");
        return (E)this.invoke(new AlterAndGetRequest(this.name, this.toData(function)));
    }

    @Override
    public E getAndAlter(IFunction<E, E> function) {
        Preconditions.isNotNull(function, "function");
        return (E)this.invoke(new GetAndAlterRequest(this.name, this.toData(function)));
    }

    @Override
    public boolean compareAndSet(E expect, E update) {
        return (Boolean)this.invoke(new CompareAndSetRequest(this.name, this.toData(expect), this.toData(update)));
    }

    @Override
    public boolean contains(E expected) {
        return (Boolean)this.invoke(new ContainsRequest(this.name, this.toData(expected)));
    }

    @Override
    public E get() {
        return (E)this.invoke(new GetRequest(this.name));
    }

    @Override
    public void set(E newValue) {
        this.invoke(new SetRequest(this.name, this.toData(newValue)));
    }

    @Override
    public void clear() {
        this.set(null);
    }

    @Override
    public E getAndSet(E newValue) {
        return (E)this.invoke(new GetAndSetRequest(this.name, this.toData(newValue)));
    }

    @Override
    public E setAndGet(E update) {
        this.invoke(new SetRequest(this.name, this.toData(update)));
        return update;
    }

    @Override
    public boolean isNull() {
        return (Boolean)this.invoke(new IsNullRequest(this.name));
    }

    @Override
    protected <T> T invoke(ClientRequest req) {
        return super.invoke(req, this.getKey());
    }

    private Data getKey() {
        if (this.key == null) {
            this.key = this.toData(this.name);
        }
        return this.key;
    }

    public String toString() {
        return "IAtomicReference{name='" + this.name + '\'' + '}';
    }
}

