/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.monitor.impl;

import com.hazelcast.com.eclipsesource.json.JsonObject;
import com.hazelcast.monitor.LocalTopicStats;
import com.hazelcast.util.Clock;
import com.hazelcast.util.JsonUtil;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class LocalTopicStatsImpl
implements LocalTopicStats {
    private static final AtomicLongFieldUpdater<LocalTopicStatsImpl> TOTAL_PUBLISHES_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalTopicStatsImpl.class, "totalPublishes");
    private static final AtomicLongFieldUpdater<LocalTopicStatsImpl> TOTAL_RECEIVED_MESSAGES_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalTopicStatsImpl.class, "totalReceivedMessages");
    private long creationTime = Clock.currentTimeMillis();
    private volatile long totalPublishes;
    private volatile long totalReceivedMessages;

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("creationTime", this.creationTime);
        root.add("totalPublishes", this.totalPublishes);
        root.add("totalReceivedMessages", this.totalReceivedMessages);
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.creationTime = JsonUtil.getLong(json, "creationTime", -1L);
        TOTAL_PUBLISHES_UPDATER.set(this, JsonUtil.getLong(json, "totalPublishes", -1L));
        TOTAL_RECEIVED_MESSAGES_UPDATER.set(this, JsonUtil.getLong(json, "totalReceivedMessages", -1L));
    }

    @Override
    public long getPublishOperationCount() {
        return this.totalPublishes;
    }

    public void incrementPublishes() {
        TOTAL_PUBLISHES_UPDATER.incrementAndGet(this);
    }

    @Override
    public long getReceiveOperationCount() {
        return this.totalReceivedMessages;
    }

    public void incrementReceives() {
        TOTAL_RECEIVED_MESSAGES_UPDATER.incrementAndGet(this);
    }
}

