/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.mapstore;

import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.MaxSizeConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.PartitioningStrategy;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.MapStoreWrapper;
import com.hazelcast.map.impl.eviction.MaxSizeChecker;
import com.hazelcast.map.impl.mapstore.MapStoreContext;
import com.hazelcast.map.impl.mapstore.MapStoreManager;
import com.hazelcast.map.impl.mapstore.MapStoreManagers;
import com.hazelcast.map.impl.mapstore.StoreConstructor;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.NodeEngine;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

final class BasicMapStoreContext
implements MapStoreContext {
    private static final int INITIAL_KEYS_REMOVE_DELAY_MINUTES = 20;
    private static final String INITIAL_KEY_LOAD_EXECUTOR = "hz:trigger-initial-load";
    private final Map<Data, Object> initialKeys = new ConcurrentHashMap<Data, Object>();
    private String mapName;
    private MapStoreManager mapStoreManager;
    private MapStoreWrapper storeWrapper;
    private MapServiceContext mapServiceContext;
    private PartitioningStrategy partitioningStrategy;
    private MapStoreConfig mapStoreConfig;
    private MaxSizeConfig maxSizeConfig;
    private volatile Future<Boolean> initialKeyLoader;

    private BasicMapStoreContext() {
    }

    @Override
    public void start() {
        this.mapStoreManager.start();
        TriggerInitialKeyLoad task = new TriggerInitialKeyLoad();
        this.initialKeyLoader = this.executeTask(INITIAL_KEY_LOAD_EXECUTOR, task);
    }

    @Override
    public void stop() {
        if (this.initialKeyLoader != null) {
            this.initialKeyLoader.cancel(true);
        }
        this.mapStoreManager.stop();
    }

    @Override
    public boolean isWriteBehindMapStoreEnabled() {
        MapStoreConfig mapStoreConfig = this.getMapStoreConfig();
        return mapStoreConfig != null && mapStoreConfig.isEnabled() && mapStoreConfig.getWriteDelaySeconds() > 0;
    }

    @Override
    public SerializationService getSerializationService() {
        return this.mapServiceContext.getNodeEngine().getSerializationService();
    }

    @Override
    public ILogger getLogger(Class clazz) {
        return this.mapServiceContext.getNodeEngine().getLogger(clazz);
    }

    @Override
    public String getMapName() {
        return this.mapName;
    }

    @Override
    public MapServiceContext getMapServiceContext() {
        return this.mapServiceContext;
    }

    @Override
    public MapStoreConfig getMapStoreConfig() {
        return this.mapStoreConfig;
    }

    @Override
    public void waitInitialLoadFinish() throws Exception {
        this.initialKeyLoader.get();
    }

    @Override
    public MapStoreManager getMapStoreManager() {
        return this.mapStoreManager;
    }

    @Override
    public Map<Data, Object> getInitialKeys() {
        return this.initialKeys;
    }

    @Override
    public MapStoreWrapper getMapStoreWrapper() {
        return this.storeWrapper;
    }

    static MapStoreContext create(MapContainer mapContainer) {
        BasicMapStoreContext context = new BasicMapStoreContext();
        String mapName = mapContainer.getName();
        MapServiceContext mapServiceContext = mapContainer.getMapServiceContext();
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        PartitioningStrategy partitioningStrategy = mapContainer.getPartitioningStrategy();
        MapConfig mapConfig = mapContainer.getMapConfig();
        MaxSizeConfig maxSizeConfig = mapConfig.getMaxSizeConfig();
        MapStoreConfig mapStoreConfig = mapConfig.getMapStoreConfig();
        ClassLoader configClassLoader = nodeEngine.getConfigClassLoader();
        Object store = StoreConstructor.createStore(mapName, mapStoreConfig, configClassLoader);
        MapStoreWrapper storeWrapper = new MapStoreWrapper(mapName, store);
        BasicMapStoreContext.setStoreImplToWritableMapStoreConfig(nodeEngine, mapName, store);
        context.setMapName(mapName);
        context.setMapStoreConfig(mapStoreConfig);
        context.setMaxSizeConfig(maxSizeConfig);
        context.setPartitioningStrategy(partitioningStrategy);
        context.setMapServiceContext(mapServiceContext);
        context.setStoreWrapper(storeWrapper);
        MapStoreManager mapStoreManager = BasicMapStoreContext.createMapStoreManager(context);
        context.setMapStoreManager(mapStoreManager);
        BasicMapStoreContext.callLifecycleSupportInit(context);
        return context;
    }

    private static void setStoreImplToWritableMapStoreConfig(NodeEngine nodeEngine, String mapName, Object store) {
        Config config = nodeEngine.getConfig();
        MapConfig mapConfig = config.getMapConfig(mapName);
        MapStoreConfig mapStoreConfig = mapConfig.getMapStoreConfig();
        mapStoreConfig.setImplementation(store);
    }

    private static MapStoreManager createMapStoreManager(MapStoreContext mapStoreContext) {
        MapStoreConfig mapStoreConfig = mapStoreContext.getMapStoreConfig();
        if (BasicMapStoreContext.isWriteBehindMapStoreEnabled(mapStoreConfig)) {
            return MapStoreManagers.createWriteBehindManager(mapStoreContext);
        }
        return MapStoreManagers.createWriteThroughManager(mapStoreContext);
    }

    private static boolean isWriteBehindMapStoreEnabled(MapStoreConfig mapStoreConfig) {
        return mapStoreConfig != null && mapStoreConfig.isEnabled() && mapStoreConfig.getWriteDelaySeconds() > 0;
    }

    private static void callLifecycleSupportInit(MapStoreContext mapStoreContext) {
        MapStoreWrapper mapStoreWrapper = mapStoreContext.getMapStoreWrapper();
        MapServiceContext mapServiceContext = mapStoreContext.getMapServiceContext();
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        HazelcastInstance hazelcastInstance = nodeEngine.getHazelcastInstance();
        MapStoreConfig mapStoreConfig = mapStoreContext.getMapStoreConfig();
        Properties properties = mapStoreConfig.getProperties();
        String mapName = mapStoreContext.getMapName();
        mapStoreWrapper.init(hazelcastInstance, properties, mapName);
    }

    private void loadInitialKeys() {
        Set keys = this.storeWrapper.loadAllKeys();
        if (keys == null || keys.isEmpty()) {
            return;
        }
        MapServiceContext mapServiceContext = this.getMapServiceContext();
        this.selectOwnedKeys(keys, mapServiceContext);
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        ExecutionService executionService = nodeEngine.getExecutionService();
        executionService.schedule(new Runnable(){

            @Override
            public void run() {
                BasicMapStoreContext.this.initialKeys.clear();
            }
        }, 20L, TimeUnit.MINUTES);
    }

    private void selectOwnedKeys(Set loadedKeys, MapServiceContext mapServiceContext) {
        Map<Data, Object> initialKeys = this.initialKeys;
        initialKeys.clear();
        PartitioningStrategy partitioningStrategy = this.partitioningStrategy;
        int maxSizePerNode = MaxSizeChecker.getApproximateMaxSize(this.getMaxSizePerNode()) - 1;
        for (Object key : loadedKeys) {
            Data dataKey = mapServiceContext.toData(key, partitioningStrategy);
            if (!mapServiceContext.isOwnedKey(dataKey)) continue;
            initialKeys.put(dataKey, key);
            if (initialKeys.size() != maxSizePerNode) continue;
            break;
        }
    }

    private int getMaxSizePerNode() {
        MaxSizeConfig maxSizeConfig = this.maxSizeConfig;
        int maxSize = -1;
        if (maxSizeConfig.getMaxSizePolicy() == MaxSizeConfig.MaxSizePolicy.PER_NODE) {
            maxSize = maxSizeConfig.getSize();
        }
        return maxSize;
    }

    private <T> Future<T> executeTask(String executorName, Callable task) {
        return this.getExecutionService().submit(executorName, task);
    }

    private ExecutionService getExecutionService() {
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        return nodeEngine.getExecutionService();
    }

    void setMapStoreManager(MapStoreManager mapStoreManager) {
        this.mapStoreManager = mapStoreManager;
    }

    void setStoreWrapper(MapStoreWrapper storeWrapper) {
        this.storeWrapper = storeWrapper;
    }

    void setMapServiceContext(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
    }

    void setMapName(String mapName) {
        this.mapName = mapName;
    }

    void setPartitioningStrategy(PartitioningStrategy partitioningStrategy) {
        this.partitioningStrategy = partitioningStrategy;
    }

    void setMapStoreConfig(MapStoreConfig mapStoreConfig) {
        this.mapStoreConfig = mapStoreConfig;
    }

    void setMaxSizeConfig(MaxSizeConfig maxSizeConfig) {
        this.maxSizeConfig = maxSizeConfig;
    }

    private final class TriggerInitialKeyLoad
    implements Callable<Boolean> {
        private TriggerInitialKeyLoad() {
        }

        @Override
        public Boolean call() throws Exception {
            BasicMapStoreContext.this.loadInitialKeys();
            return Boolean.TRUE;
        }
    }
}

