/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.config.ClientProperties;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocationServiceImpl;
import com.hazelcast.client.spi.impl.ClientListenerServiceImpl;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.executor.impl.client.RefreshableRequest;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.spi.Callback;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.util.Clock;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.ExceptionUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class ClientCallFuture<V>
implements ICompletableFuture<V>,
Callback {
    static final ILogger LOGGER = Logger.getLogger(ClientCallFuture.class);
    private final int heartBeatInterval;
    private final int retryCount;
    private final int retryWaitTime;
    private volatile Object response;
    private final ClientRequest request;
    private final ClientExecutionServiceImpl executionService;
    private final ClientInvocationServiceImpl invocationService;
    private final ClientListenerServiceImpl clientListenerService;
    private final SerializationService serializationService;
    private final EventHandler handler;
    private AtomicInteger reSendCount = new AtomicInteger();
    private volatile ClientConnection connection;
    private List<ExecutionCallbackNode> callbackNodeList = new LinkedList<ExecutionCallbackNode>();

    public ClientCallFuture(HazelcastClientInstanceImpl client, ClientRequest request, EventHandler handler) {
        ClientProperties clientProperties = client.getClientProperties();
        int interval = clientProperties.getHeartbeatInterval().getInteger();
        this.heartBeatInterval = interval > 0 ? interval : Integer.parseInt("5000");
        int retry = clientProperties.getRetryCount().getInteger();
        this.retryCount = retry > 0 ? retry : Integer.parseInt("20");
        int waitTime = clientProperties.getRetryWaitTime().getInteger();
        this.retryWaitTime = waitTime > 0 ? waitTime : Integer.parseInt("250");
        this.invocationService = (ClientInvocationServiceImpl)client.getInvocationService();
        this.executionService = (ClientExecutionServiceImpl)client.getClientExecutionService();
        this.clientListenerService = (ClientListenerServiceImpl)client.getListenerService();
        this.serializationService = client.getSerializationService();
        this.request = request;
        this.handler = handler;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.response != null;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            return this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException exception) {
            throw ExceptionUtil.rethrow(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long waitMillis;
        if (this.response == null && (waitMillis = unit.toMillis(timeout)) > 0L) {
            ClientCallFuture clientCallFuture = this;
            synchronized (clientCallFuture) {
                while (waitMillis > 0L && this.response == null) {
                    long start = Clock.currentTimeMillis();
                    this.wait(Math.min((long)this.heartBeatInterval, waitMillis));
                    long elapsed = Clock.currentTimeMillis() - start;
                    waitMillis -= elapsed;
                    if (this.isConnectionHealthy(elapsed)) continue;
                    this.notify(new TargetDisconnectedException());
                }
            }
        }
        return this.resolveResponse();
    }

    private boolean isConnectionHealthy(long elapsed) {
        if (elapsed >= (long)this.heartBeatInterval) {
            return this.connection.isHeartBeating();
        }
        return true;
    }

    public void notify(Object response) {
        if (response == null) {
            throw new IllegalArgumentException("response can't be null");
        }
        if (response instanceof TargetNotMemberException && this.resend()) {
            return;
        }
        if ((response instanceof TargetDisconnectedException || response instanceof HazelcastInstanceNotActiveException) && (this.request instanceof RetryableRequest || this.invocationService.isRedoOperation()) && this.resend()) {
            return;
        }
        this.setResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setResponse(Object response) {
        ClientCallFuture clientCallFuture = this;
        synchronized (clientCallFuture) {
            if (this.response != null && this.handler == null) {
                LOGGER.warning("The Future.set() method can only be called once. Request: " + this.request + ", current response: " + this.response + ", new response: " + response);
                return;
            }
            if (this.handler != null && !(response instanceof Throwable)) {
                this.handler.onListenerRegister();
            }
            if (this.response != null && !(response instanceof Throwable)) {
                String uuid = (String)this.serializationService.toObject(this.response);
                String alias = (String)this.serializationService.toObject(response);
                this.clientListenerService.reRegisterListener(uuid, alias, this.request.getCallId());
                return;
            }
            this.response = response;
            this.notifyAll();
        }
        for (ExecutionCallbackNode node : this.callbackNodeList) {
            this.runAsynchronous(node.callback, node.executor, node.deserialized);
        }
        this.callbackNodeList.clear();
    }

    private V resolveResponse() throws ExecutionException, TimeoutException, InterruptedException {
        if (this.response instanceof Throwable) {
            ExceptionUtil.fixRemoteStackTrace((Throwable)this.response, Thread.currentThread().getStackTrace());
            if (this.response instanceof ExecutionException) {
                throw (ExecutionException)this.response;
            }
            if (this.response instanceof TimeoutException) {
                throw (TimeoutException)this.response;
            }
            if (this.response instanceof Error) {
                throw (Error)this.response;
            }
            if (this.response instanceof InterruptedException) {
                throw (InterruptedException)this.response;
            }
            throw new ExecutionException((Throwable)this.response);
        }
        if (this.response == null) {
            throw new TimeoutException();
        }
        return (V)this.response;
    }

    @Override
    public void andThen(ExecutionCallback<V> callback) {
        this.andThen(callback, this.executionService.getAsyncExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void andThen(ExecutionCallback<V> callback, Executor executor) {
        ClientCallFuture clientCallFuture = this;
        synchronized (clientCallFuture) {
            if (this.response != null) {
                this.runAsynchronous(callback, executor, true);
                return;
            }
            this.callbackNodeList.add(new ExecutionCallbackNode(callback, executor, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void andThenInternal(ExecutionCallback<Data> callback) {
        ExecutorService executor = this.executionService.getAsyncExecutor();
        ClientCallFuture clientCallFuture = this;
        synchronized (clientCallFuture) {
            if (this.response != null) {
                this.runAsynchronous(callback, executor, false);
                return;
            }
            this.callbackNodeList.add(new ExecutionCallbackNode(callback, executor, false));
        }
    }

    public ClientRequest getRequest() {
        return this.request;
    }

    public EventHandler getHandler() {
        return this.handler;
    }

    public ClientConnection getConnection() {
        return this.connection;
    }

    public boolean resend() {
        if (this.request.isSingleConnection()) {
            return false;
        }
        if (this.handler == null && this.reSendCount.incrementAndGet() > this.retryCount) {
            return false;
        }
        if (this.handler != null) {
            this.handler.beforeListenerRegister();
        }
        if (this.request instanceof RefreshableRequest) {
            ((RefreshableRequest)((Object)this.request)).refresh();
        }
        try {
            this.sleep();
            this.executionService.execute(new ReSendTask());
        }
        catch (RejectedExecutionException e) {
            this.response = e;
            if (LOGGER.isFinestEnabled()) {
                LOGGER.finest("Retry could not be scheduled ", e);
            }
            return false;
        }
        return true;
    }

    private void sleep() {
        try {
            Thread.sleep(this.retryWaitTime);
        }
        catch (InterruptedException ignored) {
            EmptyStatement.ignore(ignored);
        }
    }

    private void runAsynchronous(final ExecutionCallback callback, Executor executor, final boolean deserialized) {
        try {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Object resp;
                        try {
                            resp = ClientCallFuture.this.resolveResponse();
                        }
                        catch (Throwable t) {
                            callback.onFailure(t);
                            return;
                        }
                        if (deserialized) {
                            resp = ClientCallFuture.this.serializationService.toObject(resp);
                        }
                        callback.onResponse(resp);
                    }
                    catch (Throwable t) {
                        LOGGER.severe("Failed to execute callback: " + callback + "! Request: " + ClientCallFuture.this.request + ", response: " + ClientCallFuture.this.response, t);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            LOGGER.warning("Execution of callback: " + callback + " is rejected!", e);
        }
    }

    public void setConnection(ClientConnection connection) {
        this.connection = connection;
    }

    class ExecutionCallbackNode {
        final ExecutionCallback callback;
        final Executor executor;
        final boolean deserialized;

        ExecutionCallbackNode(ExecutionCallback callback, Executor executor, boolean deserialized) {
            this.callback = callback;
            this.executor = executor;
            this.deserialized = deserialized;
        }
    }

    class ReSendTask
    implements Runnable {
        ReSendTask() {
        }

        @Override
        public void run() {
            try {
                ClientCallFuture.this.invocationService.reSend(ClientCallFuture.this);
            }
            catch (Exception e) {
                if (ClientCallFuture.this.handler != null) {
                    ClientCallFuture.this.clientListenerService.registerFailedListener(ClientCallFuture.this);
                }
                ClientCallFuture.this.notify(new TargetDisconnectedException());
            }
        }
    }
}

