/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.proxy.AbstractClientCollectionProxy;
import com.hazelcast.collection.client.ListAddAllRequest;
import com.hazelcast.collection.client.ListAddRequest;
import com.hazelcast.collection.client.ListGetRequest;
import com.hazelcast.collection.client.ListIndexOfRequest;
import com.hazelcast.collection.client.ListRemoveRequest;
import com.hazelcast.collection.client.ListSetRequest;
import com.hazelcast.collection.client.ListSubRequest;
import com.hazelcast.core.IList;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.SerializableCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;

public class ClientListProxy<E>
extends AbstractClientCollectionProxy<E>
implements IList<E> {
    public ClientListProxy(String serviceName, String name) {
        super(serviceName, name);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.throwExceptionIfNull(c);
        ArrayList<Data> valueList = new ArrayList<Data>(c.size());
        for (E e : c) {
            this.throwExceptionIfNull(e);
            valueList.add(this.toData(e));
        }
        ListAddAllRequest request = new ListAddAllRequest(this.getName(), valueList, index);
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public E get(int index) {
        ListGetRequest request = new ListGetRequest(this.getName(), index);
        return (E)this.invoke(request);
    }

    @Override
    public E set(int index, E element) {
        this.throwExceptionIfNull(element);
        Data value = this.toData(element);
        ListSetRequest request = new ListSetRequest(this.getName(), index, value);
        return (E)this.invoke(request);
    }

    @Override
    public void add(int index, E element) {
        this.throwExceptionIfNull(element);
        Data value = this.toData(element);
        ListAddRequest request = new ListAddRequest(this.getName(), value, index);
        this.invoke(request);
    }

    @Override
    public E remove(int index) {
        ListRemoveRequest request = new ListRemoveRequest(this.getName(), index);
        return (E)this.invoke(request);
    }

    @Override
    public int indexOf(Object o) {
        return this.indexOfInternal(o, false);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOfInternal(o, true);
    }

    private int indexOfInternal(Object o, boolean last) {
        this.throwExceptionIfNull(o);
        Data value = this.toData(o);
        ListIndexOfRequest request = new ListIndexOfRequest(this.getName(), value, last);
        Integer result = (Integer)this.invoke(request);
        return result;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.subList(-1, -1).listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        ListSubRequest request = new ListSubRequest(this.getName(), fromIndex, toIndex);
        SerializableCollection result = (SerializableCollection)this.invoke(request);
        Collection<Data> collection = result.getCollection();
        ArrayList list = new ArrayList(collection.size());
        for (Data value : collection) {
            list.add(this.toObject(value));
        }
        return list;
    }

    public String toString() {
        return "IList{name='" + this.getName() + '\'' + '}';
    }
}

