/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.operation;

import com.hazelcast.cache.impl.AbstractCacheService;
import com.hazelcast.cache.impl.CacheDataSerializerHook;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.Callback;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.spi.impl.AbstractNamedOperation;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;

public class CacheCreateConfigOperation
extends AbstractNamedOperation
implements IdentifiedDataSerializable {
    private CacheConfig config;
    private boolean createAlsoOnOthers = true;
    private boolean returnsResponse = true;
    private transient Object response;

    public CacheCreateConfigOperation() {
    }

    public CacheCreateConfigOperation(CacheConfig config) {
        this(config, true);
    }

    public CacheCreateConfigOperation(CacheConfig config, boolean createAlsoOnOthers) {
        super(config.getNameWithPrefix());
        this.config = config;
        this.createAlsoOnOthers = createAlsoOnOthers;
    }

    @Override
    public void run() throws Exception {
        NodeEngine nodeEngine;
        Collection<MemberImpl> members;
        int remoteNodeCount;
        AbstractCacheService service = (AbstractCacheService)this.getService();
        this.response = service.createCacheConfigIfAbsent(this.config);
        if (this.createAlsoOnOthers && (remoteNodeCount = (members = (nodeEngine = this.getNodeEngine()).getClusterService().getMemberList()).size() - 1) > 0) {
            this.postponeReturnResponse();
            CacheConfigCreateCallback callback = new CacheConfigCreateCallback(this.getResponseHandler(), remoteNodeCount);
            OperationService operationService = nodeEngine.getOperationService();
            for (MemberImpl member : members) {
                if (member.localMember()) continue;
                CacheCreateConfigOperation op = new CacheCreateConfigOperation(this.config, false);
                operationService.createInvocationBuilder("hz:impl:cacheService", (Operation)op, member.getAddress()).setCallback(callback).invoke();
            }
        }
    }

    private void postponeReturnResponse() {
        this.returnsResponse = false;
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    public boolean returnsResponse() {
        return this.returnsResponse;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.config);
        out.writeBoolean(this.createAlsoOnOthers);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.config = (CacheConfig)in.readObject();
        this.createAlsoOnOthers = in.readBoolean();
    }

    @Override
    public int getId() {
        return 26;
    }

    @Override
    public int getFactoryId() {
        return CacheDataSerializerHook.F_ID;
    }

    private static class CacheConfigCreateCallback
    implements Callback<Object> {
        final ResponseHandler responseHandler;
        final AtomicInteger counter;

        public CacheConfigCreateCallback(ResponseHandler responseHandler, int count) {
            this.responseHandler = responseHandler;
            this.counter = new AtomicInteger(count);
        }

        @Override
        public void notify(Object object) {
            if (this.counter.decrementAndGet() == 0) {
                this.responseHandler.sendResponse(null);
            }
        }
    }
}

