/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.ItemListenerConfig;
import com.hazelcast.config.QueueConfigReadOnly;
import com.hazelcast.config.QueueStoreConfig;
import java.util.ArrayList;
import java.util.List;

public class QueueConfig {
    public static final int DEFAULT_MAX_SIZE = 0;
    public static final int DEFAULT_SYNC_BACKUP_COUNT = 1;
    public static final int DEFAULT_ASYNC_BACKUP_COUNT = 0;
    public static final int DEFAULT_EMPTY_QUEUE_TTL = -1;
    private String name;
    private List<ItemListenerConfig> listenerConfigs;
    private int backupCount = 1;
    private int asyncBackupCount = 0;
    private int maxSize = 0;
    private int emptyQueueTtl = -1;
    private QueueStoreConfig queueStoreConfig;
    private boolean statisticsEnabled = true;
    private QueueConfigReadOnly readOnly;

    public QueueConfig() {
    }

    public QueueConfig(QueueConfig config) {
        this();
        this.name = config.name;
        this.backupCount = config.backupCount;
        this.asyncBackupCount = config.asyncBackupCount;
        this.maxSize = config.maxSize;
        this.emptyQueueTtl = config.emptyQueueTtl;
        this.statisticsEnabled = config.statisticsEnabled;
        this.queueStoreConfig = config.queueStoreConfig != null ? new QueueStoreConfig(config.queueStoreConfig) : null;
        this.listenerConfigs = new ArrayList<ItemListenerConfig>(config.getItemListenerConfigs());
    }

    public QueueConfigReadOnly getAsReadOnly() {
        if (this.readOnly == null) {
            this.readOnly = new QueueConfigReadOnly(this);
        }
        return this.readOnly;
    }

    public int getEmptyQueueTtl() {
        return this.emptyQueueTtl;
    }

    public QueueConfig setEmptyQueueTtl(int emptyQueueTtl) {
        this.emptyQueueTtl = emptyQueueTtl;
        return this;
    }

    public int getMaxSize() {
        return this.maxSize == 0 ? Integer.MAX_VALUE : this.maxSize;
    }

    public QueueConfig setMaxSize(int maxSize) {
        if (maxSize < 0) {
            throw new IllegalArgumentException("Size of the queue can not be a negative value!");
        }
        this.maxSize = maxSize;
        return this;
    }

    public int getTotalBackupCount() {
        return this.backupCount + this.asyncBackupCount;
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public QueueConfig setBackupCount(int backupCount) {
        this.backupCount = backupCount;
        return this;
    }

    public int getAsyncBackupCount() {
        return this.asyncBackupCount;
    }

    public QueueConfig setAsyncBackupCount(int asyncBackupCount) {
        this.asyncBackupCount = asyncBackupCount;
        return this;
    }

    public QueueStoreConfig getQueueStoreConfig() {
        return this.queueStoreConfig;
    }

    public QueueConfig setQueueStoreConfig(QueueStoreConfig queueStoreConfig) {
        this.queueStoreConfig = queueStoreConfig;
        return this;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public QueueConfig setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public QueueConfig setName(String name) {
        this.name = name;
        return this;
    }

    public QueueConfig addItemListenerConfig(ItemListenerConfig listenerConfig) {
        this.getItemListenerConfigs().add(listenerConfig);
        return this;
    }

    public List<ItemListenerConfig> getItemListenerConfigs() {
        if (this.listenerConfigs == null) {
            this.listenerConfigs = new ArrayList<ItemListenerConfig>();
        }
        return this.listenerConfigs;
    }

    public QueueConfig setItemListenerConfigs(List<ItemListenerConfig> listenerConfigs) {
        this.listenerConfigs = listenerConfigs;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("QueueConfig{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", listenerConfigs=").append(this.listenerConfigs);
        sb.append(", backupCount=").append(this.backupCount);
        sb.append(", asyncBackupCount=").append(this.asyncBackupCount);
        sb.append(", maxSize=").append(this.maxSize);
        sb.append(", emptyQueueTtl=").append(this.emptyQueueTtl);
        sb.append(", queueStoreConfig=").append(this.queueStoreConfig);
        sb.append(", statisticsEnabled=").append(this.statisticsEnabled);
        sb.append('}');
        return sb.toString();
    }
}

