/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.mapstore.writebehind;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.map.impl.MapStoreWrapper;
import com.hazelcast.map.impl.mapstore.AbstractMapDataStore;
import com.hazelcast.map.impl.mapstore.writebehind.DelayedEntry;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindProcessor;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindQueue;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class WriteBehindStore
extends AbstractMapDataStore<Data, Object> {
    private static final DelayedEntry TRANSIENT = new DelayedEntry();
    private final long writeDelayTime;
    private final int partitionId;
    private final AtomicInteger flushCounter;
    private final InMemoryFormat inMemoryFormat;
    private WriteBehindQueue<DelayedEntry> writeBehindQueue;
    private WriteBehindProcessor writeBehindProcessor;
    private final ConcurrentMap<Data, DelayedEntry> stagingArea;

    public WriteBehindStore(MapStoreWrapper store, SerializationService serializationService, long writeDelayTime, int partitionId, InMemoryFormat inMemoryFormat) {
        super(store, serializationService);
        this.writeDelayTime = writeDelayTime;
        this.partitionId = partitionId;
        this.stagingArea = this.createStagingArea();
        this.flushCounter = new AtomicInteger(0);
        this.inMemoryFormat = inMemoryFormat;
    }

    private ConcurrentHashMap<Data, DelayedEntry> createStagingArea() {
        return new ConcurrentHashMap<Data, DelayedEntry>();
    }

    public void setWriteBehindQueue(WriteBehindQueue<DelayedEntry> writeBehindQueue) {
        this.writeBehindQueue = writeBehindQueue;
    }

    @Override
    public Object add(Data key, Object value, long now) {
        long writeDelay = this.writeDelayTime;
        long storeTime = now + writeDelay;
        DelayedEntry<Data, Object> delayedEntry = DelayedEntry.create(key, value, storeTime, this.partitionId);
        if (InMemoryFormat.OBJECT.equals((Object)this.inMemoryFormat)) {
            value = this.toData(value);
        }
        this.add(delayedEntry);
        return value;
    }

    public void add(DelayedEntry<Data, Object> delayedEntry) {
        this.writeBehindQueue.offer(delayedEntry);
        this.stagingArea.put((Data)delayedEntry.getKey(), delayedEntry);
    }

    @Override
    public void addTransient(Data key, long now) {
        this.stagingArea.put(key, TRANSIENT);
    }

    @Override
    public Object addBackup(Data key, Object value, long time) {
        return this.add(key, value, time);
    }

    @Override
    public void remove(Data key, long now) {
        long writeDelay = this.writeDelayTime;
        long storeTime = now + writeDelay;
        DelayedEntry<Data, Object> delayedEntry = DelayedEntry.createWithNullValue(key, storeTime, this.partitionId);
        this.add(delayedEntry);
    }

    @Override
    public void removeBackup(Data key, long time) {
        this.remove(key, time);
    }

    @Override
    public void clear() {
        this.writeBehindQueue.clear();
        this.stagingArea.clear();
        this.flushCounter.set(0);
    }

    @Override
    public Object load(Data key) {
        DelayedEntry delayedEntry = this.getFromStagingArea(key);
        return delayedEntry == null ? this.getStore().load(this.toObject(key)) : this.toObject(delayedEntry.getValue());
    }

    @Override
    public Map loadAll(Collection keys) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Data, Object> map = new HashMap<Data, Object>();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Data dataKey = this.toData(key);
            DelayedEntry delayedEntry = this.getFromStagingArea(dataKey);
            if (delayedEntry == null) continue;
            Object value = delayedEntry.getValue();
            if (value != null) {
                map.put(dataKey, this.toObject(value));
            }
            iterator.remove();
        }
        map.putAll(super.loadAll(keys));
        return map;
    }

    @Override
    public boolean loadable(Data key, long lastUpdateTime, long now) {
        return !this.isInStagingArea(key, now) && !this.hasAnyWaitingOperationInWriteBehindQueue(lastUpdateTime, now);
    }

    @Override
    public int notFinishedOperationsCount() {
        return this.writeBehindQueue.size();
    }

    @Override
    public Object flush(Data key, Object value, long now, boolean backup) {
        DelayedEntry delayedEntry = (DelayedEntry)this.stagingArea.get(key);
        if (delayedEntry == TRANSIENT) {
            this.stagingArea.remove(key);
            return null;
        }
        if (this.writeBehindQueue.size() == 0) {
            return null;
        }
        this.flushCounter.incrementAndGet();
        return value;
    }

    @Override
    public Collection<Data> flush() {
        return this.writeBehindProcessor.flush(this.writeBehindQueue);
    }

    void removeProcessed(DelayedEntry entry) {
        if (entry == null) {
            return;
        }
        Object key = entry.getKey();
        this.stagingArea.remove(key, entry);
    }

    private boolean hasAnyWaitingOperationInWriteBehindQueue(long lastUpdateTime, long now) {
        long scheduledStoreTime = lastUpdateTime + this.writeDelayTime;
        return now < scheduledStoreTime;
    }

    private boolean isInStagingArea(Data key, long now) {
        DelayedEntry entry = (DelayedEntry)this.stagingArea.get(key);
        if (entry == null) {
            return false;
        }
        long storeTime = entry.getStoreTime();
        return now < storeTime;
    }

    private DelayedEntry getFromStagingArea(Data key) {
        DelayedEntry entry = (DelayedEntry)this.stagingArea.get(key);
        if (entry == null || entry == TRANSIENT) {
            return null;
        }
        return entry;
    }

    public WriteBehindQueue<DelayedEntry> getWriteBehindQueue() {
        return this.writeBehindQueue;
    }

    public void setWriteBehindProcessor(WriteBehindProcessor writeBehindProcessor) {
        this.writeBehindProcessor = writeBehindProcessor;
    }

    public AtomicInteger getFlushCounter() {
        return this.flushCounter;
    }
}

