/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web;

import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.DataSerializerHook;
import com.hazelcast.nio.serialization.FactoryIdHelper;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.web.AddSessionEntryProcessor;
import com.hazelcast.web.DestroySessionEntryProcessor;
import com.hazelcast.web.InvalidateSessionAttributesEntryProcessor;
import com.hazelcast.web.ReferenceSessionEntryProcessor;
import com.hazelcast.web.SessionAttributePredicate;

public class WebDataSerializerHook
implements DataSerializerHook {
    public static final int F_ID = FactoryIdHelper.getFactoryId("hazelcast.serialization.ds.web", -1000);
    public static final int SESSION_ATTRIBUTE_ID = 1;
    public static final int ADD_SESSION_ID = 2;
    public static final int DESTROY_SESSION_ID = 3;
    public static final int INVALIDATE_SESSION_ATTRIBUTES_ID = 4;
    public static final int REFERENCE_SESSION_ID = 5;

    @Override
    public DataSerializableFactory createFactory() {
        return new DataSerializableFactory(){

            @Override
            public IdentifiedDataSerializable create(int typeId) {
                switch (typeId) {
                    case 1: {
                        return new SessionAttributePredicate();
                    }
                    case 2: {
                        return new AddSessionEntryProcessor();
                    }
                    case 3: {
                        return new DestroySessionEntryProcessor();
                    }
                    case 4: {
                        return new InvalidateSessionAttributesEntryProcessor();
                    }
                    case 5: {
                        return new ReferenceSessionEntryProcessor();
                    }
                }
                throw new IllegalArgumentException();
            }
        };
    }

    @Override
    public int getFactoryId() {
        return F_ID;
    }
}

