/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.mapstore.writebehind;

import com.hazelcast.map.impl.mapstore.writebehind.BoundedArrayWriteBehindQueue;
import com.hazelcast.map.impl.mapstore.writebehind.CoalescedWriteBehindQueue;
import com.hazelcast.map.impl.mapstore.writebehind.DelayedEntry;
import com.hazelcast.map.impl.mapstore.writebehind.SynchronizedWriteBehindQueue;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindQueue;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public final class WriteBehindQueues {
    private WriteBehindQueues() {
    }

    public static WriteBehindQueue createSafeBoundedArrayWriteBehindQueue(int maxSizePerNode, AtomicInteger counter) {
        return WriteBehindQueues.createSafeWriteBehindQueue(new BoundedArrayWriteBehindQueue(maxSizePerNode, counter));
    }

    public static <T> WriteBehindQueue<T> createDefaultWriteBehindQueue() {
        return WriteBehindQueues.createSafeWriteBehindQueue(WriteBehindQueues.createCoalescedWriteBehindQueue());
    }

    public static <T> WriteBehindQueue<T> emptyWriteBehindQueue() {
        return EmptyWriteBehindQueueHolder.EMPTY_WRITE_BEHIND_QUEUE;
    }

    public static <T> WriteBehindQueue<T> createSafeWriteBehindQueue(WriteBehindQueue<T> queue) {
        return new SynchronizedWriteBehindQueue<T>(queue);
    }

    public static WriteBehindQueue createCoalescedWriteBehindQueue() {
        return new CoalescedWriteBehindQueue();
    }

    private static final class EmptyWriteBehindQueue<T>
    implements WriteBehindQueue<T> {
        private EmptyWriteBehindQueue() {
        }

        @Override
        public boolean offer(T t) {
            return false;
        }

        @Override
        public T get(T t) {
            return null;
        }

        @Override
        public T getFirst() {
            return null;
        }

        @Override
        public void removeFirst() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void clear() {
        }

        @Override
        public WriteBehindQueue<T> getSnapShot() {
            return WriteBehindQueues.emptyWriteBehindQueue();
        }

        @Override
        public void removeAll(Collection<T> collection) {
        }

        @Override
        public void addFront(Collection collection) {
        }

        @Override
        public void addEnd(Collection collection) {
        }

        @Override
        public List removeAll() {
            return Collections.emptyList();
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public List asList() {
            return Collections.emptyList();
        }

        @Override
        public List filterItems(long now) {
            return Collections.emptyList();
        }

        @Override
        public List<DelayedEntry> get(int count) {
            return Collections.emptyList();
        }
    }

    private static final class EmptyWriteBehindQueueHolder {
        private static final WriteBehindQueue EMPTY_WRITE_BEHIND_QUEUE = new EmptyWriteBehindQueue();

        private EmptyWriteBehindQueueHolder() {
        }
    }
}

