/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.query.impl.QueryResultEntry;
import com.hazelcast.query.impl.QueryResultEntryImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class QueryResult
implements DataSerializable {
    private Collection<Integer> partitionIds;
    private final Collection result;

    public QueryResult() {
        this.result = new LinkedHashSet();
    }

    public QueryResult(Collection<? extends QueryResultEntry> queryableEntries) {
        this.result = queryableEntries;
    }

    public Collection<Integer> getPartitionIds() {
        return this.partitionIds;
    }

    public void setPartitionIds(Collection<Integer> partitionIds) {
        this.partitionIds = partitionIds;
    }

    public void add(QueryResultEntry resultEntry) {
        this.result.add(resultEntry);
    }

    public Collection<QueryResultEntry> getResult() {
        return this.result;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        int psize = this.partitionIds == null ? 0 : this.partitionIds.size();
        out.writeInt(psize);
        if (psize > 0) {
            for (Integer partitionId : this.partitionIds) {
                out.writeInt(partitionId);
            }
        }
        int rsize = this.result.size();
        out.writeInt(rsize);
        if (rsize > 0) {
            Iterator iterator = this.result.iterator();
            for (int i = 0; i < rsize; ++i) {
                QueryResultEntryImpl queryableEntry = (QueryResultEntryImpl)iterator.next();
                queryableEntry.writeData(out);
            }
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int rsize;
        int psize = in.readInt();
        if (psize > 0) {
            this.partitionIds = new ArrayList<Integer>(psize);
            for (int i = 0; i < psize; ++i) {
                this.partitionIds.add(in.readInt());
            }
        }
        if ((rsize = in.readInt()) > 0) {
            for (int i = 0; i < rsize; ++i) {
                QueryResultEntryImpl resultEntry = new QueryResultEntryImpl();
                resultEntry.readData(in);
                this.result.add(resultEntry);
            }
        }
    }
}

