/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.management;

import com.hazelcast.cache.CacheStatistics;
import com.hazelcast.cache.impl.CacheDistributedObject;
import com.hazelcast.cache.impl.CacheStatisticsImpl;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.Client;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Member;
import com.hazelcast.core.MultiMap;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.management.SerializableClientEndPoint;
import com.hazelcast.management.TimedMemberStateFactoryHelper;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.monitor.LocalMemoryStats;
import com.hazelcast.monitor.TimedMemberState;
import com.hazelcast.monitor.impl.LocalCacheStatsImpl;
import com.hazelcast.monitor.impl.LocalExecutorStatsImpl;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.monitor.impl.LocalMemoryStatsImpl;
import com.hazelcast.monitor.impl.LocalMultiMapStatsImpl;
import com.hazelcast.monitor.impl.LocalQueueStatsImpl;
import com.hazelcast.monitor.impl.LocalTopicStatsImpl;
import com.hazelcast.monitor.impl.MemberPartitionStateImpl;
import com.hazelcast.monitor.impl.MemberStateImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.util.MapUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class TimedMemberStateFactory {
    private static final int INITIAL_PARTITION_SAFETY_CHECK_DELAY = 15;
    private static final int PARTITION_SAFETY_CHECK_PERIOD = 60;
    private final ILogger logger;
    private final HazelcastInstanceImpl instance;
    private final int maxVisibleInstanceCount;
    private final boolean cacheServiceEnabled;
    private volatile boolean memberStateSafe = true;

    public TimedMemberStateFactory(HazelcastInstanceImpl instance) {
        this.instance = instance;
        this.maxVisibleInstanceCount = instance.node.groupProperties.MC_MAX_INSTANCE_COUNT.getInteger();
        this.cacheServiceEnabled = instance.node.nodeEngine.getService("hz:impl:cacheService") != null;
        this.logger = instance.node.getLogger(TimedMemberStateFactory.class);
    }

    public void init() {
        this.instance.node.nodeEngine.getExecutionService().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                TimedMemberStateFactory.this.memberStateSafe = TimedMemberStateFactory.this.instance.getPartitionService().isLocalMemberSafe();
            }
        }, 15L, 60L, TimeUnit.SECONDS);
    }

    public TimedMemberState createTimedMemberState() {
        MemberStateImpl memberState = new MemberStateImpl();
        this.createMemberState(memberState);
        GroupConfig groupConfig = this.instance.getConfig().getGroupConfig();
        TimedMemberState timedMemberState = new TimedMemberState();
        timedMemberState.setMaster(this.instance.node.isMaster());
        timedMemberState.setMemberList(new ArrayList<String>());
        if (timedMemberState.getMaster().booleanValue()) {
            Set<Member> memberSet = this.instance.getCluster().getMembers();
            for (Member member : memberSet) {
                MemberImpl memberImpl = (MemberImpl)member;
                Address address = memberImpl.getAddress();
                timedMemberState.getMemberList().add(address.getHost() + ":" + address.getPort());
            }
        }
        timedMemberState.setMemberState(memberState);
        timedMemberState.setClusterName(groupConfig.getName());
        timedMemberState.setInstanceNames(this.getLongInstanceNames());
        return timedMemberState;
    }

    protected LocalMemoryStats getMemoryStats() {
        return new LocalMemoryStatsImpl(this.instance.getMemoryStats());
    }

    private void createMemberState(MemberStateImpl memberState) {
        Node node = this.instance.node;
        Address thisAddress = node.getThisAddress();
        InternalPartitionService partitionService = node.getPartitionService();
        InternalPartition[] partitions = partitionService.getPartitions();
        HashSet<SerializableClientEndPoint> serializableClientEndPoints = new HashSet<SerializableClientEndPoint>();
        for (Client client : this.instance.node.clientEngine.getClients()) {
            serializableClientEndPoints.add(new SerializableClientEndPoint(client));
        }
        memberState.setClients(serializableClientEndPoints);
        memberState.setAddress(thisAddress.getHost() + ":" + thisAddress.getPort());
        TimedMemberStateFactoryHelper.registerJMXBeans(this.instance, memberState);
        MemberPartitionStateImpl memberPartitionState = (MemberPartitionStateImpl)memberState.getMemberPartitionState();
        List<Integer> partitionList = memberPartitionState.getPartitions();
        for (InternalPartition partition : partitions) {
            Address owner = partition.getOwnerOrNull();
            if (owner == null || !thisAddress.equals(owner)) continue;
            partitionList.add(partition.getPartitionId());
        }
        memberPartitionState.setMigrationQueueSize(partitionService.getMigrationQueueSize());
        memberPartitionState.setMemberStateSafe(this.memberStateSafe);
        memberState.setLocalMemoryStats(this.getMemoryStats());
        ArrayList<DistributedObject> proxyObjects = new ArrayList<DistributedObject>(this.instance.getDistributedObjects());
        TimedMemberStateFactoryHelper.createRuntimeProps(memberState);
        this.createMemState(memberState, proxyObjects);
    }

    private void createMemState(MemberStateImpl memberState, Collection<DistributedObject> distributedObjects) {
        int count = 0;
        Config config = this.instance.getConfig();
        Iterator<DistributedObject> iterator = distributedObjects.iterator();
        while (iterator.hasNext() && count < this.maxVisibleInstanceCount) {
            DistributedObject distributedObject = iterator.next();
            if (distributedObject instanceof IQueue) {
                count = this.handleQueue(memberState, count, config, (IQueue)distributedObject);
                continue;
            }
            if (distributedObject instanceof ITopic) {
                count = this.handleTopic(memberState, count, config, (ITopic)distributedObject);
                continue;
            }
            if (distributedObject instanceof MultiMap) {
                count = this.handleMultimap(memberState, count, config, (MultiMap)distributedObject);
                continue;
            }
            if (distributedObject instanceof IExecutorService) {
                count = this.handleExecutorService(memberState, count, config, (IExecutorService)distributedObject);
                continue;
            }
            this.logger.finest("Distributed object ignored for monitoring: " + distributedObject.getName());
        }
        count = this.handleMap(memberState, count, this.getMapStats());
        if (this.cacheServiceEnabled) {
            ICacheService cacheService = this.getCacheService();
            for (CacheConfig cacheConfig : cacheService.getCacheConfigs()) {
                if (!cacheConfig.isStatisticsEnabled()) continue;
                CacheStatisticsImpl statistics = cacheService.getStatistics(cacheConfig.getNameWithPrefix());
                count = this.handleCache(memberState, count, cacheConfig, statistics);
            }
        }
    }

    private int handleExecutorService(MemberStateImpl memberState, int count, Config config, IExecutorService executorService) {
        if (config.findExecutorConfig(executorService.getName()).isStatisticsEnabled()) {
            LocalExecutorStatsImpl stats = (LocalExecutorStatsImpl)executorService.getLocalExecutorStats();
            memberState.putLocalExecutorStats(executorService.getName(), stats);
            return count + 1;
        }
        return count;
    }

    private int handleMultimap(MemberStateImpl memberState, int count, Config config, MultiMap multiMap) {
        if (config.findMultiMapConfig(multiMap.getName()).isStatisticsEnabled()) {
            LocalMultiMapStatsImpl stats = (LocalMultiMapStatsImpl)multiMap.getLocalMultiMapStats();
            memberState.putLocalMultiMapStats(multiMap.getName(), stats);
            return count + 1;
        }
        return count;
    }

    private int handleTopic(MemberStateImpl memberState, int count, Config config, ITopic topic) {
        if (config.findTopicConfig(topic.getName()).isStatisticsEnabled()) {
            LocalTopicStatsImpl stats = (LocalTopicStatsImpl)topic.getLocalTopicStats();
            memberState.putLocalTopicStats(topic.getName(), stats);
            return count + 1;
        }
        return count;
    }

    private int handleQueue(MemberStateImpl memberState, int count, Config config, IQueue queue) {
        if (config.findQueueConfig(queue.getName()).isStatisticsEnabled()) {
            LocalQueueStatsImpl stats = (LocalQueueStatsImpl)queue.getLocalQueueStats();
            memberState.putLocalQueueStats(queue.getName(), stats);
            return count + 1;
        }
        return count;
    }

    private int handleMap(MemberStateImpl memberState, int count, Map<String, LocalMapStatsImpl> maps) {
        for (Map.Entry<String, LocalMapStatsImpl> entry : maps.entrySet()) {
            if (count >= this.maxVisibleInstanceCount) break;
            memberState.putLocalMapStats(entry.getKey(), entry.getValue());
            ++count;
        }
        return count;
    }

    private int handleCache(MemberStateImpl memberState, int count, CacheConfig config, CacheStatistics cacheStatistics) {
        memberState.putLocalCacheStats(config.getNameWithPrefix(), new LocalCacheStatsImpl(cacheStatistics));
        return count + 1;
    }

    private Set<String> getLongInstanceNames() {
        HashSet<String> setLongInstanceNames = new HashSet<String>(this.maxVisibleInstanceCount);
        ArrayList<DistributedObject> proxyObjects = new ArrayList<DistributedObject>(this.instance.getDistributedObjects());
        this.collectInstanceNames(setLongInstanceNames, proxyObjects);
        return setLongInstanceNames;
    }

    private void collectInstanceNames(Set<String> setLongInstanceNames, Collection<DistributedObject> distributedObjects) {
        int count = 0;
        Config config = this.instance.getConfig();
        for (DistributedObject distributedObject : distributedObjects) {
            if (count >= this.maxVisibleInstanceCount) continue;
            if (distributedObject instanceof MultiMap) {
                count = this.collectMultiMapName(setLongInstanceNames, count, config, (MultiMap)distributedObject);
                continue;
            }
            if (distributedObject instanceof IQueue) {
                count = this.collectQueueName(setLongInstanceNames, count, config, (IQueue)distributedObject);
                continue;
            }
            if (distributedObject instanceof ITopic) {
                count = this.collectTopicName(setLongInstanceNames, count, config, (ITopic)distributedObject);
                continue;
            }
            if (distributedObject instanceof IExecutorService) {
                count = this.collectExecutorServiceName(setLongInstanceNames, count, config, (IExecutorService)distributedObject);
                continue;
            }
            this.logger.finest("Distributed object ignored for monitoring: " + distributedObject.getName());
        }
        count = this.collectMapName(setLongInstanceNames, count, config, this.getMapStats().keySet());
        if (this.cacheServiceEnabled) {
            for (CacheConfig cacheConfig : this.getCacheService().getCacheConfigs()) {
                if (!cacheConfig.isStatisticsEnabled()) continue;
                count = this.collectCacheName(setLongInstanceNames, count, cacheConfig);
            }
        }
    }

    private int collectExecutorServiceName(Set<String> setLongInstanceNames, int count, Config config, IExecutorService executorService) {
        if (config.findExecutorConfig(executorService.getName()).isStatisticsEnabled()) {
            setLongInstanceNames.add("e:" + executorService.getName());
            return count + 1;
        }
        return count;
    }

    private int collectTopicName(Set<String> setLongInstanceNames, int count, Config config, ITopic topic) {
        if (config.findTopicConfig(topic.getName()).isStatisticsEnabled()) {
            setLongInstanceNames.add("t:" + topic.getName());
            return count + 1;
        }
        return count;
    }

    private int collectQueueName(Set<String> setLongInstanceNames, int count, Config config, IQueue queue) {
        if (config.findQueueConfig(queue.getName()).isStatisticsEnabled()) {
            setLongInstanceNames.add("q:" + queue.getName());
            return count + 1;
        }
        return count;
    }

    private int collectMapName(Set<String> setLongInstanceNames, int count, Config config, Set<String> mapNames) {
        for (String name : mapNames) {
            if (count >= this.maxVisibleInstanceCount) continue;
            setLongInstanceNames.add("c:" + name);
            ++count;
        }
        return count;
    }

    private int collectCacheName(Set<String> setLongInstanceNames, int count, CacheConfig config) {
        if (config.isStatisticsEnabled()) {
            setLongInstanceNames.add("j:" + config.getNameWithPrefix());
            return count + 1;
        }
        return count;
    }

    private int collectMultiMapName(Set<String> setLongInstanceNames, int count, Config config, MultiMap multiMap) {
        if (config.findMultiMapConfig(multiMap.getName()).isStatisticsEnabled()) {
            setLongInstanceNames.add("m:" + multiMap.getName());
            return count + 1;
        }
        return count;
    }

    private ICacheService getCacheService() {
        CacheDistributedObject setupRef = (CacheDistributedObject)this.instance.getDistributedObject("hz:impl:cacheService", "setupRef");
        return (ICacheService)setupRef.getService();
    }

    private MapService getMapService() {
        return (MapService)this.instance.node.nodeEngine.getService("hz:impl:mapService");
    }

    private Map<String, LocalMapStatsImpl> getMapStats() {
        MapServiceContext msc = this.getMapService().getMapServiceContext();
        Map<String, MapContainer> mapContainers = msc.getMapContainers();
        Map<String, LocalMapStatsImpl> mapStats = MapUtil.createHashMap(mapContainers.size());
        for (Map.Entry<String, MapContainer> entry : mapContainers.entrySet()) {
            String mapName = entry.getKey();
            MapConfig mapConfig = entry.getValue().getMapConfig();
            if (!mapConfig.isStatisticsEnabled()) continue;
            mapStats.put(mapName, msc.getLocalMapStatsProvider().createLocalMapStats(mapName));
        }
        return mapStats;
    }
}

