/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.map.operation.BaseRemoveOperation;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import java.io.IOException;

public class RemoveIfSameOperation
extends BaseRemoveOperation {
    private Data testValue;
    private boolean successful;

    public RemoveIfSameOperation(String name, Data dataKey, Data value) {
        super(name, dataKey);
        this.testValue = value;
    }

    public RemoveIfSameOperation() {
    }

    @Override
    public void run() {
        this.successful = this.recordStore.remove(this.dataKey, this.testValue);
    }

    @Override
    public void afterRun() {
        if (this.successful) {
            this.dataOldValue = this.testValue;
            super.afterRun();
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        IOUtil.writeNullableData(out, this.testValue);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.testValue = IOUtil.readNullableData(in);
    }

    @Override
    public Object getResponse() {
        return this.successful;
    }

    @Override
    public boolean shouldBackup() {
        return this.successful;
    }

    @Override
    public void onWaitExpire() {
        this.getResponseHandler().sendResponse(null);
    }

    @Override
    public String toString() {
        return "RemoveIfSameOperation{" + this.name + "}";
    }
}

