/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.client;

import com.hazelcast.map.client.AbstractMapAddEntryListenerRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.SqlPredicate;
import java.io.IOException;

public class MapAddEntryListenerSqlRequest
extends AbstractMapAddEntryListenerRequest {
    private String predicate;
    private transient Predicate cachedPredicate;

    public MapAddEntryListenerSqlRequest() {
    }

    public MapAddEntryListenerSqlRequest(String name, boolean includeValue) {
        super(name, includeValue);
    }

    public MapAddEntryListenerSqlRequest(String name, Data key, boolean includeValue) {
        super(name, key, includeValue);
    }

    public MapAddEntryListenerSqlRequest(String name, Data key, boolean includeValue, String predicate) {
        super(name, key, includeValue);
        this.predicate = predicate;
    }

    @Override
    protected Predicate getPredicate() {
        if (this.cachedPredicate == null && this.predicate != null) {
            this.cachedPredicate = new SqlPredicate(this.predicate);
        }
        return this.cachedPredicate;
    }

    @Override
    public int getClassId() {
        return 26;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        boolean hasKey = this.key != null;
        writer.writeBoolean("key", hasKey);
        if (this.predicate == null) {
            writer.writeBoolean("pre", false);
            if (hasKey) {
                ObjectDataOutput out = writer.getRawDataOutput();
                this.key.writeData(out);
            }
        } else {
            writer.writeBoolean("pre", true);
            writer.writeUTF("p", this.predicate);
            ObjectDataOutput out = writer.getRawDataOutput();
            if (hasKey) {
                this.key.writeData(out);
            }
        }
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("name");
        this.includeValue = reader.readBoolean("i");
        boolean hasKey = reader.readBoolean("key");
        if (reader.readBoolean("pre")) {
            this.predicate = reader.readUTF("p");
            ObjectDataInput in = reader.getRawDataInput();
            if (hasKey) {
                this.key = new Data();
                this.key.readData(in);
            }
        } else if (hasKey) {
            ObjectDataInput in = reader.getRawDataInput();
            this.key = new Data();
            this.key.readData(in);
        }
    }
}

