/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.client;

import com.hazelcast.cache.impl.client.AbstractCacheRequest;
import com.hazelcast.cache.impl.operation.CacheRemoveOperation;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class CacheRemoveRequest
extends AbstractCacheRequest {
    protected Data key;
    protected Data currentValue;
    private int completionId;

    public CacheRemoveRequest() {
    }

    public CacheRemoveRequest(String name, Data key) {
        super(name);
        this.key = key;
    }

    public CacheRemoveRequest(String name, Data key, Data currentValue) {
        super(name);
        this.key = key;
        this.currentValue = currentValue;
    }

    @Override
    public int getClassId() {
        return 4;
    }

    @Override
    protected Object getKey() {
        return this.key;
    }

    @Override
    protected Operation prepareOperation() {
        return new CacheRemoveOperation(this.name, this.key, this.currentValue, this.completionId);
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeInt("c", this.completionId);
        ObjectDataOutput out = writer.getRawDataOutput();
        this.key.writeData(out);
        IOUtil.writeNullableData(out, this.currentValue);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.completionId = reader.readInt("c");
        ObjectDataInput in = reader.getRawDataInput();
        this.key = new Data();
        this.key.readData(in);
        this.currentValue = IOUtil.readNullableData(in);
    }

    @Override
    public void setCompletionId(Integer completionId) {
        this.completionId = completionId != null ? completionId : -1;
    }
}

