/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.spring.AbstractHazelcastBeanDefinitionParser;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class HazelcastTypeBeanDefinitionParser
extends AbstractHazelcastBeanDefinitionParser {
    private final String type;
    private final String methodName;

    public HazelcastTypeBeanDefinitionParser(String type) {
        this.type = type;
        this.methodName = "get" + Character.toUpperCase(type.charAt(0)) + type.substring(1);
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        SpringXmlBuilder springXmlBuilder = new SpringXmlBuilder(parserContext);
        springXmlBuilder.handle(element);
        BeanDefinitionBuilder builder = springXmlBuilder.getBuilder();
        builder.setFactoryMethod(this.methodName);
        return builder.getBeanDefinition();
    }

    private class SpringXmlBuilder
    extends AbstractHazelcastBeanDefinitionParser.SpringXmlBuilderHelper {
        private final ParserContext parserContext;
        private BeanDefinitionBuilder builder;

        public SpringXmlBuilder(ParserContext parserContext) {
            super(HazelcastTypeBeanDefinitionParser.this);
            this.parserContext = parserContext;
            this.builder = BeanDefinitionBuilder.rootBeanDefinition(HazelcastInstance.class);
        }

        public BeanDefinitionBuilder getBuilder() {
            return this.builder;
        }

        public void handle(Element element) {
            this.handleCommonBeanAttributes(element, this.builder, this.parserContext);
            NamedNodeMap attrs = element.getAttributes();
            if (attrs != null) {
                Node instanceRefNode = attrs.getNamedItem("instance-ref");
                if (instanceRefNode == null) {
                    throw new IllegalStateException("'instance-ref' attribute is required for creating Hazelcast " + HazelcastTypeBeanDefinitionParser.this.type);
                }
                String instanceRef = this.getTextContent(instanceRefNode);
                this.builder.getRawBeanDefinition().setFactoryBeanName(instanceRef);
                this.builder.addDependsOn(instanceRef);
                Node nameNode = attrs.getNamedItem("name");
                if (nameNode == null) {
                    nameNode = attrs.getNamedItem("id");
                }
                this.builder.addConstructorArgValue((Object)this.getTextContent(nameNode));
            }
        }
    }
}

