/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.topic;

import com.hazelcast.nio.Address;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.topic.TopicDataSerializerHook;
import com.hazelcast.util.Clock;
import java.io.IOException;

public class TopicEvent
implements IdentifiedDataSerializable {
    public String name;
    public long publishTime;
    public Address publisherAddress;
    public Data data;

    public TopicEvent() {
    }

    public TopicEvent(String name, Data data, Address publisherAddress) {
        this.publishTime = Clock.currentTimeMillis();
        this.publisherAddress = publisherAddress;
        this.name = name;
        this.data = data;
    }

    @Override
    public int getFactoryId() {
        return TopicDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 1;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeLong(this.publishTime);
        out.writeObject(this.publisherAddress);
        IOUtil.writeNullableData(out, this.data);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.publishTime = in.readLong();
        this.publisherAddress = (Address)in.readObject();
        this.data = IOUtil.readNullableData(in);
    }

    public String toString() {
        return "TopicEvent{name='" + this.name + '\'' + ", publishTime=" + this.publishTime + ", publisherAddress=" + this.publisherAddress + '}';
    }
}

