/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.client;

import com.hazelcast.client.PartitionClientRequest;
import com.hazelcast.client.SecureRequest;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.queue.QueuePortableHook;
import com.hazelcast.security.permission.QueuePermission;
import java.io.IOException;
import java.security.Permission;

public abstract class QueueRequest
extends PartitionClientRequest
implements Portable,
SecureRequest {
    protected String name;
    protected long timeoutMillis;

    protected QueueRequest() {
    }

    protected QueueRequest(String name) {
        this.name = name;
    }

    protected QueueRequest(String name, long timeoutMillis) {
        this.name = name;
        this.timeoutMillis = timeoutMillis;
    }

    @Override
    protected int getPartition() {
        String partitionKey = StringPartitioningStrategy.getPartitionKey(this.name);
        return this.getClientEngine().getPartitionService().getPartitionId(partitionKey);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:queueService";
    }

    @Override
    public int getFactoryId() {
        return QueuePortableHook.F_ID;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeLong("t", this.timeoutMillis);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.timeoutMillis = reader.readLong("t");
    }

    @Override
    public Permission getRequiredPermission() {
        return new QueuePermission(this.name, "read");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }
}

