/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.core.MemberLeftException;
import com.hazelcast.map.MapContextQuerySupport;
import com.hazelcast.map.MapService;
import com.hazelcast.map.MapServiceContext;
import com.hazelcast.map.QueryResult;
import com.hazelcast.map.operation.AbstractMapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.IndexService;
import com.hazelcast.query.impl.QueryResultEntryImpl;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.util.SortingUtil;
import com.hazelcast.util.executor.ManagedExecutorService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class QueryOperation
extends AbstractMapOperation {
    Predicate predicate;
    QueryResult result;
    PagingPredicate pagingPredicate;

    public QueryOperation(String mapName, Predicate predicate) {
        super(mapName);
        this.predicate = predicate;
        if (predicate instanceof PagingPredicate) {
            this.pagingPredicate = (PagingPredicate)predicate;
        }
    }

    public QueryOperation() {
    }

    @Override
    public void run() throws Exception {
        List<Integer> initialPartitions = this.mapService.getMapServiceContext().getOwnedPartitions();
        IndexService indexService = this.mapService.getMapServiceContext().getMapContainer(this.name).getIndexService();
        Set<QueryableEntry> entries = null;
        if (!this.getNodeEngine().getPartitionService().hasOnGoingMigration()) {
            entries = indexService.query(this.predicate);
        }
        this.result = new QueryResult();
        if (entries != null) {
            for (QueryableEntry entry : entries) {
                this.result.add(new QueryResultEntryImpl(entry.getKeyData(), entry.getKeyData(), entry.getValueData()));
            }
        } else if (this.pagingPredicate != null) {
            this.runParallelForPaging(initialPartitions);
        } else {
            this.runParallel(initialPartitions);
        }
        List<Integer> finalPartitions = this.mapService.getMapServiceContext().getOwnedPartitions();
        if (initialPartitions.equals(finalPartitions)) {
            this.result.setPartitionIds(finalPartitions);
        }
        if (this.mapContainer.getMapConfig().isStatisticsEnabled()) {
            MapServiceContext mapServiceContext = ((MapService)this.getService()).getMapServiceContext();
            mapServiceContext.getLocalMapStatsProvider().getLocalMapStatsImpl(this.name).incrementOtherOperations();
        }
    }

    protected void runParallel(List<Integer> initialPartitions) throws InterruptedException, ExecutionException {
        NodeEngine nodeEngine = this.getNodeEngine();
        ManagedExecutorService executor = nodeEngine.getExecutionService().getExecutor("hz:query");
        ArrayList<Future<Collection<QueryableEntry>>> lsFutures = new ArrayList<Future<Collection<QueryableEntry>>>(initialPartitions.size());
        for (Integer n : initialPartitions) {
            Future<Collection<QueryableEntry>> f = executor.submit(new PartitionCallable(n));
            lsFutures.add(f);
        }
        for (Future future : lsFutures) {
            Collection collection = (Collection)future.get();
            if (collection == null) continue;
            for (QueryableEntry entry : collection) {
                this.result.add(new QueryResultEntryImpl(entry.getKeyData(), entry.getKeyData(), entry.getValueData()));
            }
        }
        this.result.setPartitionIds(initialPartitions);
    }

    protected void runParallelForPaging(List<Integer> initialPartitions) throws InterruptedException, ExecutionException {
        NodeEngine nodeEngine = this.getNodeEngine();
        ManagedExecutorService executor = nodeEngine.getExecutionService().getExecutor("hz:query");
        ArrayList<Future<Collection<QueryableEntry>>> lsFutures = new ArrayList<Future<Collection<QueryableEntry>>>(initialPartitions.size());
        Comparator<Map.Entry> wrapperComparator = SortingUtil.newComparator(this.pagingPredicate);
        for (Integer partitionId : initialPartitions) {
            Future<Collection<QueryableEntry>> future = executor.submit(new PartitionCallable(partitionId));
            lsFutures.add(future);
        }
        List toMerge = new LinkedList();
        for (Future future : lsFutures) {
            Collection collection = (Collection)future.get();
            toMerge.addAll(collection);
        }
        Collections.sort(toMerge, wrapperComparator);
        if (toMerge.size() > this.pagingPredicate.getPageSize()) {
            toMerge = toMerge.subList(0, this.pagingPredicate.getPageSize());
        }
        for (QueryableEntry queryableEntry : toMerge) {
            this.result.add(new QueryResultEntryImpl(queryableEntry.getKeyData(), queryableEntry.getKeyData(), queryableEntry.getValueData()));
        }
    }

    @Override
    public ExceptionAction onException(Throwable throwable) {
        if (throwable instanceof MemberLeftException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        if (throwable instanceof TargetNotMemberException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onException(throwable);
    }

    @Override
    public Object getResponse() {
        return this.result;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.name);
        out.writeObject(this.predicate);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.name = in.readUTF();
        this.predicate = (Predicate)in.readObject();
        if (this.predicate instanceof PagingPredicate) {
            this.pagingPredicate = (PagingPredicate)this.predicate;
        }
    }

    private final class PartitionCallable
    implements Callable<Collection<QueryableEntry>> {
        final int partition;

        private PartitionCallable(int partitionId) {
            this.partition = partitionId;
        }

        @Override
        public Collection<QueryableEntry> call() throws Exception {
            MapContextQuerySupport mapContextQuerySupport = QueryOperation.this.mapService.getMapServiceContext().getMapContextQuerySupport();
            return mapContextQuerySupport.queryOnPartition(QueryOperation.this.name, QueryOperation.this.predicate, this.partition);
        }
    }
}

