/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.EntryViews;
import com.hazelcast.map.MapEntrySet;
import com.hazelcast.map.MapEntrySimple;
import com.hazelcast.map.MapEventPublisher;
import com.hazelcast.map.MapService;
import com.hazelcast.map.MapServiceContext;
import com.hazelcast.map.NearCacheProvider;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.operation.AbstractMapOperation;
import com.hazelcast.map.operation.PartitionWideEntryBackupOperation;
import com.hazelcast.map.record.Record;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.QueryEntry;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Iterator;

public class PartitionWideEntryOperation
extends AbstractMapOperation
implements BackupAwareOperation,
PartitionAwareOperation {
    private static final EntryEventType NO_NEED_TO_FIRE_EVENT = null;
    EntryProcessor entryProcessor;
    MapEntrySet response;

    public PartitionWideEntryOperation(String name, EntryProcessor entryProcessor) {
        super(name);
        this.entryProcessor = entryProcessor;
    }

    public PartitionWideEntryOperation() {
    }

    @Override
    public void innerBeforeRun() {
        ManagedContext managedContext = this.getNodeEngine().getSerializationService().getManagedContext();
        managedContext.initialize(this.entryProcessor);
    }

    @Override
    public void run() {
        MapServiceContext mapServiceContext = this.getMapServiceContext();
        this.response = new MapEntrySet();
        RecordStore recordStore = mapServiceContext.getRecordStore(this.getPartitionId(), this.name);
        LocalMapStatsImpl mapStats = mapServiceContext.getLocalMapStatsProvider().getLocalMapStatsImpl(this.name);
        Iterator<Record> iterator = recordStore.iterator();
        while (iterator.hasNext()) {
            EntryEventType eventType;
            Record record = iterator.next();
            long start = Clock.currentTimeMillis();
            Data key = record.getKey();
            Object valueBeforeProcess = record.getValue();
            Object valueBeforeProcessObject = mapServiceContext.toObject(valueBeforeProcess);
            Object objectKey = mapServiceContext.toObject(key);
            if (this.getPredicate() != null) {
                SerializationService ss = this.getNodeEngine().getSerializationService();
                QueryEntry queryEntry = new QueryEntry(ss, key, objectKey, valueBeforeProcessObject);
                if (!this.getPredicate().apply(queryEntry)) continue;
            }
            MapEntrySimple<Object, Object> entry = new MapEntrySimple<Object, Object>(objectKey, valueBeforeProcessObject);
            Object result = this.entryProcessor.process(entry);
            Object valueAfterProcess = entry.getValue();
            Data dataValue = null;
            if (result != null) {
                dataValue = mapServiceContext.toData(result);
                this.response.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(key, dataValue));
            }
            if (valueAfterProcess == null) {
                recordStore.remove(key);
                mapStats.incrementRemoves(this.getLatencyFrom(start));
                eventType = EntryEventType.REMOVED;
            } else {
                if (valueBeforeProcessObject == null) {
                    mapStats.incrementPuts(this.getLatencyFrom(start));
                    eventType = EntryEventType.ADDED;
                } else if (!entry.isModified()) {
                    mapStats.incrementGets(this.getLatencyFrom(start));
                    eventType = NO_NEED_TO_FIRE_EVENT;
                } else {
                    mapStats.incrementPuts(this.getLatencyFrom(start));
                    eventType = EntryEventType.UPDATED;
                }
                if (eventType != NO_NEED_TO_FIRE_EVENT) {
                    recordStore.put(new AbstractMap.SimpleImmutableEntry<Data, Object>(key, valueAfterProcess));
                }
            }
            this.fireEvent(key, valueBeforeProcess, valueAfterProcess, eventType);
            this.invalidateNearCache(key);
            this.publishWanReplicationEvent(key, dataValue, recordStore, eventType);
        }
    }

    private void fireEvent(Data dataKey, Object valueBeforeProcess, Object valueAfterProcess, EntryEventType eventType) {
        String mapName = this.name;
        MapServiceContext mapServiceContext = this.getMapServiceContext();
        if (!mapServiceContext.hasRegisteredListener(mapName) || eventType == NO_NEED_TO_FIRE_EVENT) {
            return;
        }
        Data oldValue = mapServiceContext.toData(valueBeforeProcess);
        Data value = mapServiceContext.toData(valueAfterProcess);
        MapEventPublisher mapEventPublisher = mapServiceContext.getMapEventPublisher();
        mapEventPublisher.publishEvent(this.getCallerAddress(), mapName, eventType, dataKey, oldValue, value);
    }

    private void invalidateNearCache(Data key) {
        String mapName = this.name;
        MapServiceContext mapServiceContext = this.getMapServiceContext();
        NearCacheProvider nearCacheProvider = mapServiceContext.getNearCacheProvider();
        if (nearCacheProvider.isNearCacheAndInvalidationEnabled(mapName)) {
            nearCacheProvider.invalidateAllNearCaches(mapName, key);
        }
    }

    private void publishWanReplicationEvent(Data key, Data dataValue, RecordStore recordStore, EntryEventType eventType) {
        String mapName = this.name;
        MapServiceContext mapServiceContext = this.getMapServiceContext();
        MapEventPublisher mapEventPublisher = mapServiceContext.getMapEventPublisher();
        if (this.mapContainer.getWanReplicationPublisher() != null && this.mapContainer.getWanMergePolicy() != null) {
            if (EntryEventType.REMOVED.equals((Object)eventType)) {
                mapEventPublisher.publishWanReplicationRemove(mapName, key, Clock.currentTimeMillis());
            } else {
                Record record = recordStore.getRecord(key);
                if (record != null) {
                    EntryView<Data, Data> entryView = EntryViews.createSimpleEntryView(key, dataValue, record);
                    mapEventPublisher.publishWanReplicationUpdate(mapName, entryView);
                }
            }
        }
    }

    private MapServiceContext getMapServiceContext() {
        MapService mapService = (MapService)this.getService();
        return mapService.getMapServiceContext();
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    protected Predicate getPredicate() {
        return null;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.entryProcessor = (EntryProcessor)in.readObject();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.entryProcessor);
    }

    public String toString() {
        return "PartitionWideEntryOperation{}";
    }

    @Override
    public boolean shouldBackup() {
        return this.entryProcessor.getBackupProcessor() != null;
    }

    @Override
    public int getSyncBackupCount() {
        return 0;
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapContainer.getTotalBackupCount();
    }

    @Override
    public Operation getBackupOperation() {
        EntryBackupProcessor backupProcessor = this.entryProcessor.getBackupProcessor();
        return backupProcessor != null ? new PartitionWideEntryBackupOperation(this.name, backupProcessor) : null;
    }

    private long getLatencyFrom(long begin) {
        return Clock.currentTimeMillis() - begin;
    }
}

