/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.EntryViews;
import com.hazelcast.map.MapEntrySimple;
import com.hazelcast.map.MapEventPublisher;
import com.hazelcast.map.MapServiceContext;
import com.hazelcast.map.operation.EntryBackupOperation;
import com.hazelcast.map.operation.LockAwareOperation;
import com.hazelcast.map.record.Record;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.AbstractMap;

public class EntryOperation
extends LockAwareOperation
implements BackupAwareOperation {
    private static final EntryEventType NO_NEED_TO_FIRE_EVENT = null;
    protected Object oldValue;
    private EntryProcessor entryProcessor;
    private EntryEventType eventType;
    private Object response;

    public EntryOperation(String name, Data dataKey, EntryProcessor entryProcessor) {
        super(name, dataKey);
        this.entryProcessor = entryProcessor;
    }

    public EntryOperation() {
    }

    @Override
    public void innerBeforeRun() {
        ManagedContext managedContext = this.getNodeEngine().getSerializationService().getManagedContext();
        managedContext.initialize(this.entryProcessor);
    }

    @Override
    public void run() {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        long start = System.currentTimeMillis();
        this.oldValue = this.recordStore.getMapEntry(this.dataKey).getValue();
        LocalMapStatsImpl mapStats = mapServiceContext.getLocalMapStatsProvider().getLocalMapStatsImpl(this.name);
        Object valueBeforeProcess = mapServiceContext.toObject(this.oldValue);
        MapEntrySimple<Object, Object> entry = new MapEntrySimple<Object, Object>(mapServiceContext.toObject(this.dataKey), valueBeforeProcess);
        this.response = mapServiceContext.toData(this.entryProcessor.process(entry));
        Object valueAfterProcess = entry.getValue();
        if (this.oldValue == null && valueAfterProcess == null) {
            this.eventType = NO_NEED_TO_FIRE_EVENT;
        } else if (valueAfterProcess == null) {
            this.recordStore.remove(this.dataKey);
            mapStats.incrementRemoves(this.getLatencyFrom(start));
            this.eventType = EntryEventType.REMOVED;
        } else {
            if (this.oldValue == null) {
                mapStats.incrementPuts(this.getLatencyFrom(start));
                this.eventType = EntryEventType.ADDED;
            } else if (!entry.isModified()) {
                mapStats.incrementGets(this.getLatencyFrom(start));
                this.eventType = NO_NEED_TO_FIRE_EVENT;
            } else {
                mapStats.incrementPuts(this.getLatencyFrom(start));
                this.eventType = EntryEventType.UPDATED;
            }
            if (this.eventType != NO_NEED_TO_FIRE_EVENT) {
                this.recordStore.put(new AbstractMap.SimpleImmutableEntry<Data, Object>(this.dataKey, entry.getValue()));
                this.dataValue = mapServiceContext.toData(entry.getValue());
            }
        }
    }

    @Override
    public void afterRun() throws Exception {
        super.afterRun();
        if (this.eventType == NO_NEED_TO_FIRE_EVENT) {
            return;
        }
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        MapEventPublisher mapEventPublisher = mapServiceContext.getMapEventPublisher();
        String serviceName = mapServiceContext.serviceName();
        InMemoryFormat format = this.mapContainer.getMapConfig().getInMemoryFormat();
        EventService eventService = mapServiceContext.getNodeEngine().getEventService();
        if (eventService.hasEventRegistration(serviceName, this.name)) {
            if (format == InMemoryFormat.OBJECT && this.eventType != EntryEventType.REMOVED) {
                this.oldValue = null;
            }
            this.mapService.getMapServiceContext().getMapEventPublisher().publishEvent(this.getCallerAddress(), this.name, this.eventType, this.dataKey, mapServiceContext.toData(this.oldValue), this.dataValue);
        }
        this.invalidateNearCaches();
        if (this.mapContainer.getWanReplicationPublisher() != null && this.mapContainer.getWanMergePolicy() != null) {
            if (EntryEventType.REMOVED.equals((Object)this.eventType)) {
                mapEventPublisher.publishWanReplicationRemove(this.name, this.dataKey, Clock.currentTimeMillis());
            } else {
                Record record = this.recordStore.getRecord(this.dataKey);
                if (record != null) {
                    Data dataValueAsData = mapServiceContext.toData(this.dataValue);
                    EntryView<Data, Data> entryView = EntryViews.createSimpleEntryView(this.dataKey, dataValueAsData, record);
                    mapEventPublisher.publishWanReplicationUpdate(this.name, entryView);
                }
            }
        }
    }

    @Override
    public void onWaitExpire() {
        this.getResponseHandler().sendResponse(null);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.entryProcessor = (EntryProcessor)in.readObject();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.entryProcessor);
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    public String toString() {
        return "EntryOperation{}";
    }

    @Override
    public Operation getBackupOperation() {
        EntryBackupProcessor backupProcessor = this.entryProcessor.getBackupProcessor();
        return backupProcessor != null ? new EntryBackupOperation(this.name, this.dataKey, backupProcessor) : null;
    }

    @Override
    public boolean shouldBackup() {
        return this.entryProcessor.getBackupProcessor() != null;
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }

    private long getLatencyFrom(long begin) {
        return Clock.currentTimeMillis() - begin;
    }
}

