/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.client;

import com.hazelcast.client.SecureRequest;
import com.hazelcast.concurrent.lock.client.AbstractLockRequest;
import com.hazelcast.map.MapPortableHook;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.ObjectNamespace;
import java.io.IOException;
import java.security.Permission;

public class MapLockRequest
extends AbstractLockRequest
implements SecureRequest {
    private String name;

    public MapLockRequest() {
    }

    public MapLockRequest(String name, Data key, long threadId) {
        super(key, threadId);
        this.name = name;
    }

    public MapLockRequest(String name, Data key, long threadId, long ttl, long timeout) {
        super(key, threadId, ttl, timeout);
        this.name = name;
    }

    @Override
    protected ObjectNamespace getNamespace() {
        return new DefaultObjectNamespace("hz:impl:mapService", this.name);
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 17;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        super.write(writer);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        super.read(reader);
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "lock");
    }

    @Override
    public String getDistributedObjectType() {
        return "hz:impl:mapService";
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }
}

