/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.IMapEvent;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.Member;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.DataAwareEntryEvent;
import com.hazelcast.map.EntryEventData;
import com.hazelcast.map.EventData;
import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapEventData;
import com.hazelcast.map.MapServiceContext;
import com.hazelcast.spi.EventPublishingService;
import com.hazelcast.spi.NodeEngine;
import java.util.logging.Level;

class MapEventPublishingService
implements EventPublishingService<EventData, EntryListener> {
    private MapServiceContext mapServiceContext;
    private NodeEngine nodeEngine;
    private ILogger logger;

    protected MapEventPublishingService(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
        this.logger = this.nodeEngine.getLogger(this.getClass());
    }

    private void incrementEventStats(IMapEvent event) {
        String mapName = event.getName();
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(mapName);
        if (mapContainer.getMapConfig().isStatisticsEnabled()) {
            this.mapServiceContext.getLocalMapStatsProvider().getLocalMapStatsImpl(mapName).incrementReceivedEvents();
        }
    }

    @Override
    public void dispatchEvent(EventData eventData, EntryListener listener) {
        if (eventData instanceof EntryEventData) {
            this.dispatchEntryEventData(eventData, listener);
        } else if (eventData instanceof MapEventData) {
            this.dispatchMapEventData(eventData, listener);
        } else {
            throw new IllegalArgumentException("Unknown map event data");
        }
    }

    private void dispatchMapEventData(EventData eventData, EntryListener listener) {
        MapEventData mapEventData = (MapEventData)eventData;
        Member member = this.getMemberOrNull(eventData);
        if (member == null) {
            return;
        }
        MapEvent event = this.createMapEvent(mapEventData, member);
        this.dispatch0(event, listener);
        this.incrementEventStats(event);
    }

    private MapEvent createMapEvent(MapEventData mapEventData, Member member) {
        return new MapEvent(mapEventData.getMapName(), member, mapEventData.getEventType(), mapEventData.getNumberOfEntries());
    }

    private void dispatchEntryEventData(EventData eventData, EntryListener listener) {
        EntryEventData entryEventData = (EntryEventData)eventData;
        Member member = this.getMemberOrNull(eventData);
        DataAwareEntryEvent event = this.createDataAwareEntryEvent(entryEventData, member);
        this.dispatch0(event, listener);
        this.incrementEventStats(event);
    }

    private Member getMemberOrNull(EventData eventData) {
        MemberImpl member = this.nodeEngine.getClusterService().getMember(eventData.getCaller());
        if (member == null && this.logger.isLoggable(Level.INFO)) {
            this.logger.info("Dropping event " + eventData + " from unknown address:" + eventData.getCaller());
        }
        return member;
    }

    private DataAwareEntryEvent createDataAwareEntryEvent(EntryEventData entryEventData, Member member) {
        return new DataAwareEntryEvent(member, entryEventData.getEventType(), entryEventData.getMapName(), entryEventData.getDataKey(), entryEventData.getDataNewValue(), entryEventData.getDataOldValue(), this.nodeEngine.getSerializationService());
    }

    private void dispatch0(IMapEvent event, EntryListener listener) {
        switch (event.getEventType()) {
            case ADDED: {
                listener.entryAdded((EntryEvent)event);
                break;
            }
            case EVICTED: {
                listener.entryEvicted((EntryEvent)event);
                break;
            }
            case UPDATED: {
                listener.entryUpdated((EntryEvent)event);
                break;
            }
            case REMOVED: {
                listener.entryRemoved((EntryEvent)event);
                break;
            }
            case EVICT_ALL: {
                listener.mapEvicted((MapEvent)event);
                break;
            }
            case CLEAR_ALL: {
                listener.mapCleared((MapEvent)event);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid event type: " + (Object)((Object)event.getEventType()));
            }
        }
    }
}

