/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.GlobalSerializerConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractXmlConfigHelper {
    private static final ILogger LOGGER = Logger.getLogger(AbstractXmlConfigHelper.class);
    protected boolean domLevel3 = true;

    protected String xmlToJavaName(String name) {
        StringBuilder builder = new StringBuilder();
        char[] charArray = name.toCharArray();
        boolean dash = false;
        StringBuilder token = new StringBuilder();
        for (char aCharArray : charArray) {
            if (aCharArray == '-') {
                this.appendToken(builder, token);
                dash = true;
                continue;
            }
            token.append(dash ? Character.toUpperCase(aCharArray) : aCharArray);
            dash = false;
        }
        this.appendToken(builder, token);
        return builder.toString();
    }

    protected void appendToken(StringBuilder builder, StringBuilder token) {
        String string = token.toString();
        if ("Jvm".equals(string)) {
            string = "JVM";
        }
        builder.append(string);
        token.setLength(0);
    }

    protected String getTextContent(Node node) {
        if (node != null) {
            String text = this.domLevel3 ? node.getTextContent() : this.getTextContentOld(node);
            return text != null ? text.trim() : "";
        }
        return "";
    }

    private String getTextContentOld(Node node) {
        Node child = node.getFirstChild();
        if (child != null) {
            Node next = child.getNextSibling();
            if (next == null) {
                return this.hasTextContent(child) ? child.getNodeValue() : "";
            }
            StringBuilder buf = new StringBuilder();
            this.appendTextContents(node, buf);
            return buf.toString();
        }
        return "";
    }

    private void appendTextContents(Node node, StringBuilder buf) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!this.hasTextContent(child)) continue;
            buf.append(child.getNodeValue());
        }
    }

    protected final boolean hasTextContent(Node node) {
        short nodeType = node.getNodeType();
        return nodeType != 8 && nodeType != 7;
    }

    public final String cleanNodeName(Node node) {
        return AbstractXmlConfigHelper.cleanNodeName(node.getNodeName());
    }

    public static String cleanNodeName(String nodeName) {
        String name = nodeName;
        if (name != null) {
            name = nodeName.replaceAll("\\w+:", "").toLowerCase();
        }
        return name;
    }

    protected boolean checkTrue(String value) {
        return "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value);
    }

    protected int getIntegerValue(String parameterName, String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            LOGGER.info(parameterName + " parameter value, [" + value + "], is not a proper integer. Default value, [" + defaultValue + "], will be used!");
            LOGGER.warning(e);
            return defaultValue;
        }
    }

    protected String getAttribute(Node node, String attName) {
        Node attNode = node.getAttributes().getNamedItem(attName);
        if (attNode == null) {
            return null;
        }
        return this.getTextContent(attNode);
    }

    protected SocketInterceptorConfig parseSocketInterceptorConfig(Node node) {
        SocketInterceptorConfig socketInterceptorConfig = new SocketInterceptorConfig();
        NamedNodeMap atts = node.getAttributes();
        Node enabledNode = atts.getNamedItem("enabled");
        boolean enabled = enabledNode != null && this.checkTrue(this.getTextContent(enabledNode).trim());
        socketInterceptorConfig.setEnabled(enabled);
        for (Node n : new IterableNodeList(node.getChildNodes())) {
            String nodeName = AbstractXmlConfigHelper.cleanNodeName(n.getNodeName());
            if ("class-name".equals(nodeName)) {
                socketInterceptorConfig.setClassName(this.getTextContent(n).trim());
                continue;
            }
            if (!"properties".equals(nodeName)) continue;
            this.fillProperties(n, socketInterceptorConfig.getProperties());
        }
        return socketInterceptorConfig;
    }

    protected void fillProperties(Node node, Properties properties) {
        if (properties == null) {
            return;
        }
        for (Node n : new IterableNodeList(node.getChildNodes())) {
            if (n.getNodeType() == 3 || n.getNodeType() == 8) continue;
            String name = AbstractXmlConfigHelper.cleanNodeName(n.getNodeName());
            String propertyName = "property".equals(name) ? this.getTextContent(n.getAttributes().getNamedItem("name")).trim() : name;
            String value = this.getTextContent(n).trim();
            properties.setProperty(propertyName, value);
        }
    }

    protected SerializationConfig parseSerialization(Node node) {
        SerializationConfig serializationConfig = new SerializationConfig();
        for (Node child : new IterableNodeList(node.getChildNodes())) {
            String value;
            String name = this.cleanNodeName(child);
            if ("portable-version".equals(name)) {
                value = this.getTextContent(child);
                serializationConfig.setPortableVersion(this.getIntegerValue(name, value, 0));
                continue;
            }
            if ("check-class-def-errors".equals(name)) {
                value = this.getTextContent(child);
                serializationConfig.setCheckClassDefErrors(this.checkTrue(value));
                continue;
            }
            if ("use-native-byte-order".equals(name)) {
                serializationConfig.setUseNativeByteOrder(this.checkTrue(this.getTextContent(child)));
                continue;
            }
            if ("byte-order".equals(name)) {
                value = this.getTextContent(child);
                ByteOrder byteOrder = null;
                if (ByteOrder.BIG_ENDIAN.toString().equals(value)) {
                    byteOrder = ByteOrder.BIG_ENDIAN;
                } else if (ByteOrder.LITTLE_ENDIAN.toString().equals(value)) {
                    byteOrder = ByteOrder.LITTLE_ENDIAN;
                }
                serializationConfig.setByteOrder(byteOrder != null ? byteOrder : ByteOrder.BIG_ENDIAN);
                continue;
            }
            if ("enable-compression".equals(name)) {
                serializationConfig.setEnableCompression(this.checkTrue(this.getTextContent(child)));
                continue;
            }
            if ("enable-shared-object".equals(name)) {
                serializationConfig.setEnableSharedObject(this.checkTrue(this.getTextContent(child)));
                continue;
            }
            if ("allow-unsafe".equals(name)) {
                serializationConfig.setAllowUnsafe(this.checkTrue(this.getTextContent(child)));
                continue;
            }
            if ("data-serializable-factories".equals(name)) {
                this.fillDataSerializableFactories(child, serializationConfig);
                continue;
            }
            if ("portable-factories".equals(name)) {
                this.fillPortableFactories(child, serializationConfig);
                continue;
            }
            if (!"serializers".equals(name)) continue;
            this.fillSerializers(child, serializationConfig);
        }
        return serializationConfig;
    }

    protected void fillDataSerializableFactories(Node node, SerializationConfig serializationConfig) {
        for (Node child : new IterableNodeList(node.getChildNodes())) {
            String name = this.cleanNodeName(child);
            if (!"data-serializable-factory".equals(name)) continue;
            String value = this.getTextContent(child);
            Node factoryIdNode = child.getAttributes().getNamedItem("factory-id");
            if (factoryIdNode == null) {
                throw new IllegalArgumentException("'factory-id' attribute of 'data-serializable-factory' is required!");
            }
            int factoryId = Integer.parseInt(this.getTextContent(factoryIdNode));
            serializationConfig.addDataSerializableFactoryClass(factoryId, value);
        }
    }

    protected void fillPortableFactories(Node node, SerializationConfig serializationConfig) {
        for (Node child : new IterableNodeList(node.getChildNodes())) {
            String name = this.cleanNodeName(child);
            if (!"portable-factory".equals(name)) continue;
            String value = this.getTextContent(child);
            Node factoryIdNode = child.getAttributes().getNamedItem("factory-id");
            if (factoryIdNode == null) {
                throw new IllegalArgumentException("'factory-id' attribute of 'portable-factory' is required!");
            }
            int factoryId = Integer.parseInt(this.getTextContent(factoryIdNode));
            serializationConfig.addPortableFactoryClass(factoryId, value);
        }
    }

    protected void fillSerializers(Node node, SerializationConfig serializationConfig) {
        for (Node child : new IterableNodeList(node.getChildNodes())) {
            String name = this.cleanNodeName(child);
            String value = this.getTextContent(child);
            if ("serializer".equals(name)) {
                SerializerConfig serializerConfig = new SerializerConfig();
                serializerConfig.setClassName(value);
                String typeClassName = this.getAttribute(child, "type-class");
                serializerConfig.setTypeClassName(typeClassName);
                serializationConfig.addSerializerConfig(serializerConfig);
                continue;
            }
            if (!"global-serializer".equals(name)) continue;
            GlobalSerializerConfig globalSerializerConfig = new GlobalSerializerConfig();
            globalSerializerConfig.setClassName(value);
            serializationConfig.setGlobalSerializerConfig(globalSerializerConfig);
        }
    }

    public static class IterableNodeList
    implements Iterable<Node> {
        private final NodeList parent;
        private final int maximum;
        private final short nodeType;

        public IterableNodeList(Node node) {
            this(node.getChildNodes());
        }

        public IterableNodeList(NodeList list) {
            this(list, 0);
        }

        public IterableNodeList(Node node, short nodeType) {
            this(node.getChildNodes(), nodeType);
        }

        public IterableNodeList(NodeList parent, short nodeType) {
            this.parent = parent;
            this.nodeType = nodeType;
            this.maximum = parent.getLength();
        }

        @Override
        public Iterator<Node> iterator() {
            return new Iterator<Node>(){
                private int index;
                private Node next;

                private boolean findNext() {
                    this.next = null;
                    while (this.index < IterableNodeList.this.maximum) {
                        Node item = IterableNodeList.this.parent.item(this.index);
                        if (IterableNodeList.this.nodeType == 0 || item.getNodeType() == IterableNodeList.this.nodeType) {
                            this.next = item;
                            return true;
                        }
                        ++this.index;
                    }
                    return false;
                }

                @Override
                public boolean hasNext() {
                    return this.findNext();
                }

                @Override
                public Node next() {
                    if (this.findNext()) {
                        ++this.index;
                        return this.next;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

