/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.idgen;

import com.hazelcast.concurrent.idgen.IdGeneratorService;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.spi.AbstractDistributedObject;
import com.hazelcast.spi.NodeEngine;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class IdGeneratorProxy
extends AbstractDistributedObject<IdGeneratorService>
implements IdGenerator {
    public static final int BLOCK_SIZE = 10000;
    private static final AtomicIntegerFieldUpdater<IdGeneratorProxy> RESIDUE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(IdGeneratorProxy.class, "residue");
    private static final AtomicLongFieldUpdater<IdGeneratorProxy> LOCAL_UPDATER = AtomicLongFieldUpdater.newUpdater(IdGeneratorProxy.class, "local");
    private final String name;
    private final IAtomicLong blockGenerator;
    private volatile int residue = 10000;
    private volatile long local = -1L;

    public IdGeneratorProxy(IAtomicLong blockGenerator, String name, NodeEngine nodeEngine, IdGeneratorService service) {
        super(nodeEngine, service);
        this.name = name;
        this.blockGenerator = blockGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(long id) {
        if (id <= 0L) {
            return false;
        }
        long step = id / 10000L;
        IdGeneratorProxy idGeneratorProxy = this;
        synchronized (idGeneratorProxy) {
            boolean init = this.blockGenerator.compareAndSet(0L, step + 1L);
            if (init) {
                LOCAL_UPDATER.set(this, step);
                RESIDUE_UPDATER.set(this, (int)(id % 10000L) + 1);
            }
            return init;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long newId() {
        int value = RESIDUE_UPDATER.getAndIncrement(this);
        if (value >= 10000) {
            IdGeneratorProxy idGeneratorProxy = this;
            synchronized (idGeneratorProxy) {
                value = this.residue;
                if (value >= 10000) {
                    LOCAL_UPDATER.set(this, this.blockGenerator.getAndIncrement());
                    RESIDUE_UPDATER.set(this, 0);
                }
                return this.newId();
            }
        }
        return this.local * 10000L + (long)value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:idGeneratorService";
    }

    @Override
    protected void postDestroy() {
        this.blockGenerator.destroy();
        LOCAL_UPDATER.set(this, -1L);
        RESIDUE_UPDATER.set(this, 10000);
    }
}

