/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.ClientImpl;
import com.hazelcast.client.ClientPrincipal;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.LifecycleServiceImpl;
import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.connection.AddressProvider;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.connection.nio.ClientConnectionManagerImpl;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.impl.AwsAddressProvider;
import com.hazelcast.client.spi.impl.ClusterListenerThread;
import com.hazelcast.client.spi.impl.DefaultAddressProvider;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.core.Client;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.InitialMembershipEvent;
import com.hazelcast.core.InitialMembershipListener;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.util.Clock;
import com.hazelcast.util.UuidUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

public class ClientClusterServiceImpl
implements ClientClusterService {
    private static final ILogger LOGGER = Logger.getLogger(ClientClusterService.class);
    private final HazelcastClient client;
    private final ClientConnectionManagerImpl connectionManager;
    private final ClusterListenerThread clusterThread;
    private final AtomicReference<Map<Address, MemberImpl>> membersRef = new AtomicReference();
    private final ConcurrentMap<String, MembershipListener> listeners = new ConcurrentHashMap<String, MembershipListener>();

    public ClientClusterServiceImpl(HazelcastClient client) {
        this.client = client;
        this.connectionManager = (ClientConnectionManagerImpl)client.getConnectionManager();
        this.clusterThread = this.createListenerThread();
        ClientConfig clientConfig = this.getClientConfig();
        List<ListenerConfig> listenerConfigs = client.getClientConfig().getListenerConfigs();
        if (listenerConfigs != null && !listenerConfigs.isEmpty()) {
            for (ListenerConfig listenerConfig : listenerConfigs) {
                EventListener listener = listenerConfig.getImplementation();
                if (listener == null) {
                    try {
                        listener = (EventListener)ClassLoaderUtil.newInstance(clientConfig.getClassLoader(), listenerConfig.getClassName());
                    }
                    catch (Exception e) {
                        LOGGER.severe(e);
                    }
                }
                if (!(listener instanceof MembershipListener)) continue;
                this.addMembershipListenerWithoutInit((MembershipListener)listener);
            }
        }
    }

    ClusterListenerThread createListenerThread() {
        ClientAwsConfig awsConfig = this.client.getClientConfig().getNetworkConfig().getAwsConfig();
        LinkedList<AddressProvider> addressProvider = new LinkedList<AddressProvider>();
        addressProvider.add(new DefaultAddressProvider(this.getClientConfig().getNetworkConfig()));
        if (awsConfig != null && awsConfig.isEnabled()) {
            try {
                addressProvider.add(new AwsAddressProvider(awsConfig));
            }
            catch (NoClassDefFoundError e) {
                LOGGER.log(Level.WARNING, "hazelcast-cloud.jar might be missing!");
                throw e;
            }
        }
        return new ClusterListenerThread(this.client.getThreadGroup(), this.client.getName() + ".cluster-listener", addressProvider);
    }

    @Override
    public MemberImpl getMember(Address address) {
        Map<Address, MemberImpl> members = this.membersRef.get();
        return members != null ? members.get(address) : null;
    }

    @Override
    public MemberImpl getMember(String uuid) {
        Collection<MemberImpl> memberList = this.getMemberList();
        for (MemberImpl member : memberList) {
            if (!uuid.equals(member.getUuid())) continue;
            return member;
        }
        return null;
    }

    @Override
    public Collection<MemberImpl> getMemberList() {
        Map<Address, MemberImpl> members = this.membersRef.get();
        return members != null ? members.values() : Collections.emptySet();
    }

    @Override
    public Address getMasterAddress() {
        Collection<MemberImpl> memberList = this.getMemberList();
        return !memberList.isEmpty() ? memberList.iterator().next().getAddress() : null;
    }

    @Override
    public int getSize() {
        return this.getMemberList().size();
    }

    @Override
    public long getClusterTime() {
        return Clock.currentTimeMillis();
    }

    public Client getLocalClient() {
        ClientPrincipal cp = this.connectionManager.getPrincipal();
        ClientConnection conn = this.clusterThread.getConnection();
        return new ClientImpl(cp != null ? cp.getUuid() : null, conn != null ? conn.getLocalSocketAddress() : null);
    }

    SerializationService getSerializationService() {
        return this.client.getSerializationService();
    }

    public String addMembershipListenerWithInit(MembershipListener listener) {
        String id = UuidUtil.buildRandomUuidString();
        this.listeners.put(id, listener);
        if (listener instanceof InitialMembershipListener) {
            Cluster cluster = this.client.getCluster();
            ((InitialMembershipListener)listener).init(new InitialMembershipEvent(cluster, cluster.getMembers()));
        }
        return id;
    }

    public String addMembershipListenerWithoutInit(MembershipListener listener) {
        String id = UUID.randomUUID().toString();
        this.listeners.put(id, listener);
        return id;
    }

    private void initMembershipListener() {
        for (MembershipListener membershipListener : this.listeners.values()) {
            if (!(membershipListener instanceof InitialMembershipListener)) continue;
            Cluster cluster = this.client.getCluster();
            ((InitialMembershipListener)membershipListener).init(new InitialMembershipEvent(cluster, cluster.getMembers()));
        }
    }

    public boolean removeMembershipListener(String registrationId) {
        return this.listeners.remove(registrationId) != null;
    }

    public void start() {
        this.clusterThread.init(this.client);
        this.clusterThread.start();
        try {
            this.clusterThread.await();
        }
        catch (InterruptedException e) {
            throw new HazelcastException(e);
        }
        this.initMembershipListener();
    }

    public void stop() {
        this.clusterThread.shutdown();
    }

    void fireConnectionEvent(boolean disconnected) {
        LifecycleServiceImpl lifecycleService = (LifecycleServiceImpl)this.client.getLifecycleService();
        LifecycleEvent.LifecycleState state = disconnected ? LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED : LifecycleEvent.LifecycleState.CLIENT_CONNECTED;
        lifecycleService.fireLifecycleEvent(state);
    }

    private ClientConfig getClientConfig() {
        return this.client.getClientConfig();
    }

    String membersString() {
        StringBuilder sb = new StringBuilder("\n\nMembers [");
        Collection<MemberImpl> members = this.getMemberList();
        sb.append(members != null ? members.size() : 0);
        sb.append("] {");
        if (members != null) {
            for (Member member : members) {
                sb.append("\n\t").append(member);
            }
        }
        sb.append("\n}\n");
        return sb.toString();
    }

    void fireMembershipEvent(final MembershipEvent event) {
        this.client.getClientExecutionService().execute(new Runnable(){

            @Override
            public void run() {
                for (MembershipListener listener : ClientClusterServiceImpl.this.listeners.values()) {
                    if (event.getEventType() == 1) {
                        listener.memberAdded(event);
                        continue;
                    }
                    listener.memberRemoved(event);
                }
            }
        });
    }

    void fireMemberAttributeEvent(final MemberAttributeEvent event) {
        this.client.getClientExecutionService().execute(new Runnable(){

            @Override
            public void run() {
                for (MembershipListener listener : ClientClusterServiceImpl.this.listeners.values()) {
                    listener.memberAttributeChanged(event);
                }
            }
        });
    }

    Map<Address, MemberImpl> getMembersRef() {
        return this.membersRef.get();
    }

    void setMembersRef(Map<Address, MemberImpl> map) {
        this.membersRef.set(map);
    }
}

