/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.ClientEndpointManager;
import com.hazelcast.client.ClientEngine;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Connection;
import com.hazelcast.util.Clock;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class ClientHeartbeatMonitor
implements Runnable {
    private final ClientEndpointManager clientEndpointManager;
    private final ClientEngine clientEngine;
    private final long heartbeatTimeoutSeconds;
    private final ILogger logger = Logger.getLogger(ClientHeartbeatMonitor.class);
    private final int defaultHeartbeatTimeout = 60;

    public ClientHeartbeatMonitor(long heartbeatTimeoutSeconds, ClientEndpointManager endpointManager, ClientEngine clientEngine) {
        this.clientEndpointManager = endpointManager;
        this.clientEngine = clientEngine;
        this.heartbeatTimeoutSeconds = heartbeatTimeoutSeconds <= 0L ? 60L : heartbeatTimeoutSeconds;
    }

    @Override
    public void run() {
        String memberUuid = this.clientEngine.getLocalMember().getUuid();
        for (ClientEndpoint clientEndpoint : this.clientEndpointManager.getEndpoints()) {
            long currentTimeInMillis;
            long timeoutInMillis;
            Connection connection;
            long lastTimePackageReceived;
            if (clientEndpoint.isFirstConnection() || (lastTimePackageReceived = (connection = clientEndpoint.getConnection()).lastReadTime()) + (timeoutInMillis = TimeUnit.SECONDS.toMillis(this.heartbeatTimeoutSeconds)) >= (currentTimeInMillis = Clock.currentTimeMillis()) || !memberUuid.equals(clientEndpoint.getPrincipal().getOwnerUuid())) continue;
            this.logger.log(Level.WARNING, "Client heartbeat is timed out , closing connection to " + connection);
            connection.close();
        }
    }
}

