/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.AuthenticationRequest;
import com.hazelcast.client.ClientDisconnectionOperation;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.ClientEndpointManager;
import com.hazelcast.client.ClientEngine;
import com.hazelcast.client.ClientHeartbeatMonitor;
import com.hazelcast.client.ClientRequest;
import com.hazelcast.client.ClientResponse;
import com.hazelcast.client.PostJoinClientOperation;
import com.hazelcast.cluster.ClusterService;
import com.hazelcast.config.Config;
import com.hazelcast.core.Client;
import com.hazelcast.core.ClientListener;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.nio.tcp.TcpIpConnectionManager;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.spi.CoreService;
import com.hazelcast.spi.EventPublishingService;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MemberAttributeServiceEvent;
import com.hazelcast.spi.MembershipAwareService;
import com.hazelcast.spi.MembershipServiceEvent;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.PostJoinAwareService;
import com.hazelcast.spi.ProxyService;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.ResponseHandlerFactory;
import com.hazelcast.transaction.TransactionManagerService;
import com.hazelcast.util.executor.ExecutorType;
import java.security.Permission;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.security.auth.login.LoginException;

public class ClientEngineImpl
implements ClientEngine,
CoreService,
PostJoinAwareService,
ManagedService,
MembershipAwareService,
EventPublishingService<ClientEndpoint, ClientListener> {
    public static final String SERVICE_NAME = "hz:core:clientEngine";
    private static final int ENDPOINT_REMOVE_DELAY_MS = 10;
    private static final int THREADS_PER_CORE = 10;
    private static final int EXECUTOR_QUEUE_CAPACITY_PER_CORE = 100000;
    private static final int HEART_BEAT_CHECK_INTERVAL_SECONDS = 10;
    private final Node node;
    private final NodeEngineImpl nodeEngine;
    private final Executor executor;
    private final SerializationService serializationService;
    private final ConcurrentMap<String, String> ownershipMappings = new ConcurrentHashMap<String, String>();
    private final ClientEndpointManager endpointManager;
    private final ILogger logger;
    private final ConnectionListener connectionListener = new ConnectionListenerImpl();

    public ClientEngineImpl(Node node) {
        this.node = node;
        this.serializationService = node.getSerializationService();
        this.nodeEngine = node.nodeEngine;
        this.endpointManager = new ClientEndpointManager(this, this.nodeEngine);
        int coreSize = Runtime.getRuntime().availableProcessors();
        this.executor = this.nodeEngine.getExecutionService().register("hz:client", coreSize * 10, coreSize * 100000, ExecutorType.CONCRETE);
        this.logger = node.getLogger(ClientEngine.class);
        long heartbeatNoHeartBeatsSeconds = node.groupProperties.CLIENT_MAX_NO_HEARTBEAT_SECONDS.getInteger();
        ClientHeartbeatMonitor heartBeatMonitor = new ClientHeartbeatMonitor(heartbeatNoHeartBeatsSeconds, this.endpointManager, this);
        ExecutionService executionService = this.nodeEngine.getExecutionService();
        executionService.scheduleWithFixedDelay(heartBeatMonitor, 10L, 10L, TimeUnit.SECONDS);
    }

    public ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    @Override
    public int getClientEndpointCount() {
        return this.endpointManager.size();
    }

    public void handlePacket(Packet packet) {
        this.executor.execute(new ClientPacketProcessor(packet));
    }

    @Override
    public InternalPartitionService getPartitionService() {
        return this.nodeEngine.getPartitionService();
    }

    @Override
    public ClusterService getClusterService() {
        return this.nodeEngine.getClusterService();
    }

    @Override
    public EventService getEventService() {
        return this.nodeEngine.getEventService();
    }

    @Override
    public ProxyService getProxyService() {
        return this.nodeEngine.getProxyService();
    }

    void sendResponse(ClientEndpoint endpoint, Object response, int callId, boolean isError, boolean isEvent) {
        Data data = this.serializationService.toData(response);
        ClientResponse clientResponse = new ClientResponse(data, callId, isError);
        this.sendResponse(endpoint, clientResponse, isEvent);
    }

    private void sendResponse(ClientEndpoint endpoint, ClientResponse response, boolean isEvent) {
        Data resultData = this.serializationService.toData(response);
        Connection conn = endpoint.getConnection();
        Packet packet = new Packet(resultData, this.serializationService.getPortableContext());
        if (isEvent) {
            packet.setHeader(2);
        }
        conn.write(packet);
    }

    @Override
    public TransactionManagerService getTransactionManagerService() {
        return this.nodeEngine.getTransactionManagerService();
    }

    @Override
    public Address getMasterAddress() {
        return this.node.getMasterAddress();
    }

    @Override
    public Address getThisAddress() {
        return this.node.getThisAddress();
    }

    @Override
    public MemberImpl getLocalMember() {
        return this.node.getLocalMember();
    }

    @Override
    public Config getConfig() {
        return this.node.getConfig();
    }

    @Override
    public ILogger getLogger(Class clazz) {
        return this.node.getLogger(clazz);
    }

    public ClientEndpointManager getEndpointManager() {
        return this.endpointManager;
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.node.securityContext;
    }

    void bind(ClientEndpoint endpoint) {
        Connection conn = endpoint.getConnection();
        if (conn instanceof TcpIpConnection) {
            Address address = new Address(conn.getRemoteSocketAddress());
            TcpIpConnectionManager connectionManager = (TcpIpConnectionManager)this.node.getConnectionManager();
            connectionManager.bind((TcpIpConnection)conn, address, null, false);
        }
        this.sendClientEvent(endpoint);
    }

    void sendClientEvent(ClientEndpoint endpoint) {
        if (!endpoint.isFirstConnection()) {
            EventService eventService = this.nodeEngine.getEventService();
            Collection<EventRegistration> regs = eventService.getRegistrations(SERVICE_NAME, SERVICE_NAME);
            eventService.publishEvent(SERVICE_NAME, regs, (Object)endpoint, endpoint.getUuid().hashCode());
        }
    }

    @Override
    public void dispatchEvent(ClientEndpoint event, ClientListener listener) {
        if (event.isAuthenticated()) {
            listener.clientConnected(event);
        } else {
            listener.clientDisconnected(event);
        }
    }

    @Override
    public void memberAdded(MembershipServiceEvent event) {
    }

    @Override
    public void memberRemoved(MembershipServiceEvent event) {
        block3: {
            if (event.getMember().localMember()) {
                return;
            }
            String deadMemberUuid = event.getMember().getUuid();
            try {
                this.nodeEngine.getExecutionService().schedule(new DestroyEndpointTask(deadMemberUuid), 10L, TimeUnit.SECONDS);
            }
            catch (RejectedExecutionException e) {
                if (!this.logger.isFinestEnabled()) break block3;
                this.logger.finest(e);
            }
        }
    }

    @Override
    public void memberAttributeChanged(MemberAttributeServiceEvent event) {
    }

    public Collection<Client> getClients() {
        HashSet<Client> clients = new HashSet<Client>();
        for (ClientEndpoint endpoint : this.endpointManager.getEndpoints()) {
            if (endpoint.isFirstConnection()) continue;
            clients.add(endpoint);
        }
        return clients;
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.node.getConnectionManager().addConnectionListener(this.connectionListener);
    }

    @Override
    public void reset() {
    }

    @Override
    public void shutdown(boolean terminate) {
        for (ClientEndpoint endpoint : this.endpointManager.getEndpoints()) {
            try {
                endpoint.destroy();
            }
            catch (LoginException e) {
                this.logger.finest(e.getMessage());
            }
            try {
                Connection conn = endpoint.getConnection();
                if (!conn.live()) continue;
                conn.close();
            }
            catch (Exception e) {
                this.logger.finest(e);
            }
        }
        this.endpointManager.clear();
        this.ownershipMappings.clear();
    }

    void addOwnershipMapping(String clientUuid, String ownerUuid) {
        this.ownershipMappings.put(clientUuid, ownerUuid);
    }

    void removeOwnershipMapping(String clientUuid) {
        this.ownershipMappings.remove(clientUuid);
    }

    private ClientDisconnectionOperation createClientDisconnectionOperation(String clientUuid) {
        ClientDisconnectionOperation op = new ClientDisconnectionOperation(clientUuid);
        op.setNodeEngine(this.nodeEngine).setServiceName(SERVICE_NAME).setService(this).setResponseHandler(ResponseHandlerFactory.createEmptyResponseHandler());
        return op;
    }

    @Override
    public Operation getPostJoinOperation() {
        return this.ownershipMappings.isEmpty() ? null : new PostJoinClientOperation(this.ownershipMappings);
    }

    private class DestroyEndpointTask
    implements Runnable {
        private final String deadMemberUuid;

        public DestroyEndpointTask(String deadMemberUuid) {
            this.deadMemberUuid = deadMemberUuid;
        }

        @Override
        public void run() {
            ClientEngineImpl.this.endpointManager.removeEndpoints(this.deadMemberUuid);
            this.removeMappings();
        }

        void removeMappings() {
            Iterator iterator = ClientEngineImpl.this.ownershipMappings.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String clientUuid = (String)entry.getKey();
                String memberUuid = (String)entry.getValue();
                if (!this.deadMemberUuid.equals(memberUuid)) continue;
                iterator.remove();
                ClientDisconnectionOperation op = ClientEngineImpl.this.createClientDisconnectionOperation(clientUuid);
                ClientEngineImpl.this.nodeEngine.getOperationService().runOperationOnCallingThread(op);
            }
        }
    }

    private final class ConnectionListenerImpl
    implements ConnectionListener {
        private ConnectionListenerImpl() {
        }

        @Override
        public void connectionAdded(Connection conn) {
        }

        @Override
        public void connectionRemoved(Connection connection) {
            if (connection.isClient() && connection instanceof TcpIpConnection && ClientEngineImpl.this.nodeEngine.isActive()) {
                String ownerUuid;
                ClientEndpoint endpoint = ClientEngineImpl.this.endpointManager.getEndpoint(connection);
                if (endpoint == null) {
                    return;
                }
                if (!endpoint.isFirstConnection()) {
                    return;
                }
                String localMemberUuid = ClientEngineImpl.this.node.getLocalMember().getUuid();
                if (localMemberUuid.equals(ownerUuid = endpoint.getPrincipal().getOwnerUuid())) {
                    this.callDisconnectionOperation(endpoint);
                }
            }
        }

        private void callDisconnectionOperation(ClientEndpoint endpoint) {
            Collection<MemberImpl> memberList = ClientEngineImpl.this.nodeEngine.getClusterService().getMemberList();
            OperationService operationService = ClientEngineImpl.this.nodeEngine.getOperationService();
            ClientDisconnectionOperation op = ClientEngineImpl.this.createClientDisconnectionOperation(endpoint.getUuid());
            operationService.runOperationOnCallingThread(op);
            for (MemberImpl member : memberList) {
                if (member.localMember()) continue;
                op = ClientEngineImpl.this.createClientDisconnectionOperation(endpoint.getUuid());
                operationService.send(op, member.getAddress());
            }
        }
    }

    private final class ClientPacketProcessor
    implements Runnable {
        final Packet packet;

        private ClientPacketProcessor(Packet packet) {
            this.packet = packet;
        }

        @Override
        public void run() {
            Connection conn = this.packet.getConn();
            ClientEndpoint endpoint = ClientEngineImpl.this.endpointManager.getEndpoint(conn);
            ClientRequest request = null;
            try {
                request = this.loadRequest();
                if (request == null) {
                    this.handlePacketWithNullRequest();
                } else if (request instanceof AuthenticationRequest) {
                    endpoint = ClientEngineImpl.this.endpointManager.createEndpoint(conn);
                    if (endpoint != null) {
                        this.processRequest(endpoint, request);
                    } else {
                        this.handleEndpointNotCreatedConnectionNotAlive();
                    }
                } else if (endpoint == null) {
                    this.handleMissingEndpoint(conn);
                } else if (endpoint.isAuthenticated()) {
                    this.processRequest(endpoint, request);
                } else {
                    this.handleAuthenticationFailure(endpoint, request);
                }
            }
            catch (Throwable e) {
                this.handleProcessingFailure(endpoint, request, e);
            }
        }

        private ClientRequest loadRequest() {
            Data data = this.packet.getData();
            return (ClientRequest)ClientEngineImpl.this.serializationService.toObject(data);
        }

        private void handleEndpointNotCreatedConnectionNotAlive() {
            ClientEngineImpl.this.logger.warning("Dropped: " + this.packet + " -> endpoint not created for AuthenticationRequest, " + "connection not alive");
        }

        private void handlePacketWithNullRequest() {
            ClientEngineImpl.this.logger.warning("Dropped: " + this.packet + " -> null request");
        }

        private void handleMissingEndpoint(Connection conn) {
            if (conn.live()) {
                ClientEngineImpl.this.logger.severe("Dropping: " + this.packet + " -> no endpoint found for live connection.");
            } else if (ClientEngineImpl.this.logger.isFinestEnabled()) {
                ClientEngineImpl.this.logger.finest("Dropping: " + this.packet + " -> no endpoint found for dead connection.");
            }
        }

        private void handleProcessingFailure(ClientEndpoint endpoint, ClientRequest request, Throwable e) {
            Level level;
            Level level2 = level = ClientEngineImpl.this.nodeEngine.isActive() ? Level.SEVERE : Level.FINEST;
            if (ClientEngineImpl.this.logger.isLoggable(level)) {
                if (request == null) {
                    ClientEngineImpl.this.logger.log(level, e.getMessage(), e);
                } else {
                    ClientEngineImpl.this.logger.log(level, "While executing request: " + request + " -> " + e.getMessage(), e);
                }
            }
            if (request != null && endpoint != null) {
                endpoint.sendResponse(e, request.getCallId());
            }
        }

        private void processRequest(ClientEndpoint endpoint, ClientRequest request) throws Exception {
            request.setEndpoint(endpoint);
            this.initService(request);
            request.setClientEngine(ClientEngineImpl.this);
            Credentials credentials = endpoint.getCredentials();
            request.setSerializationService(ClientEngineImpl.this.serializationService);
            request.setOperationService(ClientEngineImpl.this.nodeEngine.getOperationService());
            this.interceptBefore(credentials, request);
            this.checkPermissions(endpoint, request);
            request.process();
            this.interceptAfter(credentials, request);
        }

        private void interceptBefore(Credentials credentials, ClientRequest request) {
            SecurityContext securityContext = ClientEngineImpl.this.getSecurityContext();
            String methodName = request.getMethodName();
            if (securityContext != null && methodName != null) {
                String objectType = request.getDistributedObjectType();
                String objectName = request.getDistributedObjectName();
                securityContext.interceptBefore(credentials, objectType, objectName, methodName, request.getParameters());
            }
        }

        private void interceptAfter(Credentials credentials, ClientRequest request) {
            SecurityContext securityContext = ClientEngineImpl.this.getSecurityContext();
            String methodName = request.getMethodName();
            if (securityContext != null && methodName != null) {
                String objectType = request.getDistributedObjectType();
                String objectName = request.getDistributedObjectName();
                securityContext.interceptAfter(credentials, objectType, objectName, methodName);
            }
        }

        private void checkPermissions(ClientEndpoint endpoint, ClientRequest request) {
            Permission permission;
            SecurityContext securityContext = ClientEngineImpl.this.getSecurityContext();
            if (securityContext != null && (permission = request.getRequiredPermission()) != null) {
                securityContext.checkPermission(endpoint.getSubject(), permission);
            }
        }

        private void initService(ClientRequest request) {
            String serviceName = request.getServiceName();
            if (serviceName == null) {
                return;
            }
            Object service = ClientEngineImpl.this.nodeEngine.getService(serviceName);
            if (service == null) {
                if (ClientEngineImpl.this.nodeEngine.isActive()) {
                    throw new IllegalArgumentException("No service registered with name: " + serviceName);
                }
                throw new HazelcastInstanceNotActiveException();
            }
            request.setService(service);
        }

        private void handleAuthenticationFailure(ClientEndpoint endpoint, ClientRequest request) {
            RuntimeException exception;
            if (ClientEngineImpl.this.nodeEngine.isActive()) {
                String message = "Client " + endpoint + " must authenticate before any operation.";
                ClientEngineImpl.this.logger.severe(message);
                exception = new AuthenticationException(message);
            } else {
                exception = new HazelcastInstanceNotActiveException();
            }
            endpoint.sendResponse(exception, request.getCallId());
            ClientEngineImpl.this.endpointManager.removeEndpoint(endpoint);
        }
    }
}

