/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util.executor;

import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.executor.AbstractExecutorThreadFactory;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public final class PoolExecutorThreadFactory
extends AbstractExecutorThreadFactory {
    private final String threadNamePrefix;
    private final AtomicInteger idGen = new AtomicInteger(0);
    private final Queue<Integer> idQ = new LinkedBlockingQueue<Integer>(1000);

    public PoolExecutorThreadFactory(ThreadGroup threadGroup, String threadNamePrefix, ClassLoader classLoader) {
        super(threadGroup, classLoader);
        this.threadNamePrefix = threadNamePrefix;
    }

    @Override
    protected Thread createThread(Runnable r) {
        Integer id = this.idQ.poll();
        if (id == null) {
            id = this.idGen.incrementAndGet();
        }
        String name = this.threadNamePrefix + id;
        return new ManagedThread(r, name, id);
    }

    private class ManagedThread
    extends Thread {
        protected final int id;

        public ManagedThread(Runnable target, String name, int id) {
            super(PoolExecutorThreadFactory.this.threadGroup, target, name);
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                super.run();
            }
            catch (OutOfMemoryError e) {
                OutOfMemoryErrorDispatcher.onOutOfMemory(e);
            }
            finally {
                try {
                    PoolExecutorThreadFactory.this.idQ.offer(this.id);
                }
                catch (Throwable ignored) {
                    EmptyStatement.ignore(ignored);
                }
            }
        }
    }
}

