/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.core.ManagedContext;
import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.nio.BufferObjectDataOutput;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.DefaultPortableReader;
import com.hazelcast.nio.serialization.DefaultPortableWriter;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.MorphingPortableReader;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableContext;
import com.hazelcast.nio.serialization.PortableContextAwareInputStream;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.PortableVersionHelper;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

final class PortableSerializer
implements StreamSerializer<Portable> {
    private final PortableContext context;
    private final Map<Integer, PortableFactory> factories = new HashMap<Integer, PortableFactory>();

    PortableSerializer(PortableContext context, Map<Integer, ? extends PortableFactory> portableFactories) {
        this.context = context;
        this.factories.putAll(portableFactories);
    }

    @Override
    public int getTypeId() {
        return -1;
    }

    @Override
    public void write(ObjectDataOutput out, Portable p) throws IOException {
        if (p.getClassId() == 0) {
            throw new IllegalArgumentException("Portable class id cannot be zero!");
        }
        if (!(out instanceof BufferObjectDataOutput)) {
            throw new IllegalArgumentException("ObjectDataOutput must be instance of BufferObjectDataOutput!");
        }
        ClassDefinition cd = this.context.lookupOrRegisterClassDefinition(p);
        BufferObjectDataOutput bufferedOut = (BufferObjectDataOutput)out;
        DefaultPortableWriter writer = new DefaultPortableWriter(this, bufferedOut, cd);
        p.writePortable(writer);
        writer.end();
    }

    @Override
    public Portable read(ObjectDataInput in) throws IOException {
        if (!(in instanceof PortableContextAwareInputStream)) {
            throw new IllegalArgumentException("ObjectDataInput must be instance of PortableContextAwareInputStream!");
        }
        PortableContextAwareInputStream ctxIn = (PortableContextAwareInputStream)((Object)in);
        int factoryId = ctxIn.getFactoryId();
        int classId = ctxIn.getClassId();
        int version = ctxIn.getVersion();
        return this.read(in, factoryId, classId, version);
    }

    Portable read(ObjectDataInput in, int factoryId, int classId, int version) throws IOException {
        if (!(in instanceof BufferObjectDataInput)) {
            throw new IllegalArgumentException("ObjectDataInput must be instance of BufferObjectDataInput!");
        }
        Portable portable = this.createNewPortableInstance(factoryId, classId);
        BufferObjectDataInput bufferedIn = (BufferObjectDataInput)in;
        int effectiveVersion = version;
        if (version < 0) {
            effectiveVersion = this.context.getVersion();
        }
        int currentVersion = this.findCurrentVersion(factoryId, classId, portable);
        ClassDefinition cd = this.context.lookup(factoryId, classId, effectiveVersion);
        if (cd == null) {
            throw new HazelcastSerializationException("Could not find class-definition for factory-id: " + factoryId + ", class-id: " + classId + ", version: " + effectiveVersion);
        }
        DefaultPortableReader reader = currentVersion == effectiveVersion ? new DefaultPortableReader(this, bufferedIn, cd) : new MorphingPortableReader(this, bufferedIn, cd);
        portable.readPortable(reader);
        reader.end();
        return portable;
    }

    private int findCurrentVersion(int factoryId, int classId, Portable portable) {
        int currentVersion = this.context.getClassVersion(factoryId, classId);
        if (currentVersion < 0 && (currentVersion = PortableVersionHelper.getVersion(portable, this.context.getVersion())) > 0) {
            this.context.setClassVersion(factoryId, classId, currentVersion);
        }
        return currentVersion;
    }

    private Portable createNewPortableInstance(int factoryId, int classId) {
        PortableFactory portableFactory = this.factories.get(factoryId);
        if (portableFactory == null) {
            throw new HazelcastSerializationException("Could not find PortableFactory for factory-id: " + factoryId);
        }
        Portable portable = portableFactory.create(classId);
        if (portable == null) {
            throw new HazelcastSerializationException("Could not create Portable for class-id: " + classId);
        }
        return portable;
    }

    Portable readAndInitialize(BufferObjectDataInput in, int factoryId, int classId, int version) throws IOException {
        Portable p = this.read(in, factoryId, classId, version);
        ManagedContext managedContext = this.context.getManagedContext();
        return managedContext != null ? (Portable)managedContext.initialize(p) : p;
    }

    @Override
    public void destroy() {
        this.factories.clear();
    }
}

