/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.monitor.impl;

import com.hazelcast.com.eclipsesource.json.JsonObject;
import com.hazelcast.com.eclipsesource.json.JsonValue;
import com.hazelcast.map.MapDataSerializerHook;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.impl.NearCacheStatsImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.util.Clock;
import com.hazelcast.util.JsonUtil;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class LocalMapStatsImpl
implements LocalMapStats,
IdentifiedDataSerializable {
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> LAST_ACCESS_TIME_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "lastAccessTime");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> LAST_UPDATE_TIME_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "lastUpdateTime");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> HITS_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "hits");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> NUMBER_OF_OTHER_OPERATIONS_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "numberOfOtherOperations");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> NUMBER_OF_EVENTS_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "numberOfEvents");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> GET_COUNT_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "getCount");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> PUT_COUNT_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "putCount");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> REMOVE_COUNT_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "removeCount");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> TOTAL_GET_LATENCIES_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "totalGetLatencies");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> TOTAL_PUT_LATENCIES_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "totalPutLatencies");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> TOTAL_REMOVE_LATENCIES_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "totalRemoveLatencies");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> MAX_GET_LATENCY_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "maxGetLatency");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> MAX_PUT_LATENCY_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "maxPutLatency");
    private static final AtomicLongFieldUpdater<LocalMapStatsImpl> MAX_REMOVE_LATENCY_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalMapStatsImpl.class, "maxRemoveLatency");
    private volatile long lastAccessTime;
    private volatile long lastUpdateTime;
    private volatile long hits;
    private volatile long numberOfOtherOperations;
    private volatile long numberOfEvents;
    private volatile long getCount;
    private volatile long putCount;
    private volatile long removeCount;
    private volatile long totalGetLatencies;
    private volatile long totalPutLatencies;
    private volatile long totalRemoveLatencies;
    private volatile long maxGetLatency;
    private volatile long maxPutLatency;
    private volatile long maxRemoveLatency;
    private long creationTime = Clock.currentTimeMillis();
    private long ownedEntryCount;
    private long backupEntryCount;
    private long ownedEntryMemoryCost;
    private long backupEntryMemoryCost;
    private long heapCost;
    private long lockedEntryCount;
    private long dirtyEntryCount;
    private int backupCount;
    private NearCacheStatsImpl nearCacheStats;

    public void init() {
        this.ownedEntryCount = 0L;
        this.backupEntryCount = 0L;
        this.ownedEntryMemoryCost = 0L;
        this.backupEntryMemoryCost = 0L;
        this.heapCost = 0L;
        this.lockedEntryCount = 0L;
        this.dirtyEntryCount = 0L;
        this.backupCount = 0;
        HITS_UPDATER.set(this, 0L);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.getCount);
        out.writeLong(this.putCount);
        out.writeLong(this.removeCount);
        out.writeLong(this.numberOfOtherOperations);
        out.writeLong(this.numberOfEvents);
        out.writeLong(this.lastAccessTime);
        out.writeLong(this.lastUpdateTime);
        out.writeLong(this.hits);
        out.writeLong(this.ownedEntryCount);
        out.writeLong(this.backupEntryCount);
        out.writeInt(this.backupCount);
        out.writeLong(this.ownedEntryMemoryCost);
        out.writeLong(this.backupEntryMemoryCost);
        out.writeLong(this.creationTime);
        out.writeLong(this.lockedEntryCount);
        out.writeLong(this.dirtyEntryCount);
        out.writeLong(this.totalGetLatencies);
        out.writeLong(this.totalPutLatencies);
        out.writeLong(this.totalRemoveLatencies);
        out.writeLong(this.maxGetLatency);
        out.writeLong(this.maxPutLatency);
        out.writeLong(this.maxRemoveLatency);
        out.writeLong(this.heapCost);
        boolean hasNearCache = this.nearCacheStats != null;
        out.writeBoolean(hasNearCache);
        if (hasNearCache) {
            this.nearCacheStats.writeData(out);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        GET_COUNT_UPDATER.set(this, in.readLong());
        PUT_COUNT_UPDATER.set(this, in.readLong());
        REMOVE_COUNT_UPDATER.set(this, in.readLong());
        NUMBER_OF_OTHER_OPERATIONS_UPDATER.set(this, in.readLong());
        NUMBER_OF_EVENTS_UPDATER.set(this, in.readLong());
        LAST_ACCESS_TIME_UPDATER.set(this, in.readLong());
        LAST_UPDATE_TIME_UPDATER.set(this, in.readLong());
        HITS_UPDATER.set(this, in.readLong());
        this.ownedEntryCount = in.readLong();
        this.backupEntryCount = in.readLong();
        this.backupCount = in.readInt();
        this.ownedEntryMemoryCost = in.readLong();
        this.backupEntryMemoryCost = in.readLong();
        this.creationTime = in.readLong();
        this.lockedEntryCount = in.readLong();
        this.dirtyEntryCount = in.readLong();
        TOTAL_GET_LATENCIES_UPDATER.set(this, in.readLong());
        TOTAL_PUT_LATENCIES_UPDATER.set(this, in.readLong());
        TOTAL_REMOVE_LATENCIES_UPDATER.set(this, in.readLong());
        MAX_GET_LATENCY_UPDATER.set(this, in.readLong());
        MAX_PUT_LATENCY_UPDATER.set(this, in.readLong());
        MAX_REMOVE_LATENCY_UPDATER.set(this, in.readLong());
        this.heapCost = in.readLong();
        boolean hasNearCache = in.readBoolean();
        if (hasNearCache) {
            this.nearCacheStats = new NearCacheStatsImpl();
            this.nearCacheStats.readData(in);
        }
    }

    @Override
    public long getOwnedEntryCount() {
        return this.ownedEntryCount;
    }

    public void setOwnedEntryCount(long ownedEntryCount) {
        this.ownedEntryCount = ownedEntryCount;
    }

    public void incrementOwnedEntryCount(long ownedEntryCount) {
        this.ownedEntryCount += ownedEntryCount;
    }

    @Override
    public long getBackupEntryCount() {
        return this.backupEntryCount;
    }

    public void setBackupEntryCount(long backupEntryCount) {
        this.backupEntryCount = backupEntryCount;
    }

    public void incrementBackupEntryCount(long backupEntryCount) {
        this.backupEntryCount += backupEntryCount;
    }

    @Override
    public int getBackupCount() {
        return this.backupCount;
    }

    public void setBackupCount(int backupCount) {
        this.backupCount = backupCount;
    }

    @Override
    public long getOwnedEntryMemoryCost() {
        return this.ownedEntryMemoryCost;
    }

    public void incrementOwnedEntryMemoryCost(long ownedEntryMemoryCost) {
        this.ownedEntryMemoryCost += ownedEntryMemoryCost;
    }

    @Override
    public long getBackupEntryMemoryCost() {
        return this.backupEntryMemoryCost;
    }

    public void incrementBackupEntryMemoryCost(long backupEntryMemoryCost) {
        this.backupEntryMemoryCost += backupEntryMemoryCost;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(long lastAccessTime) {
        LAST_ACCESS_TIME_UPDATER.set(this, Math.max(this.lastAccessTime, lastAccessTime));
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        LAST_UPDATE_TIME_UPDATER.set(this, Math.max(this.lastUpdateTime, lastUpdateTime));
    }

    @Override
    public long getHits() {
        return this.hits;
    }

    public void setHits(long hits) {
        HITS_UPDATER.set(this, hits);
    }

    public void incrementHits(long hits) {
        HITS_UPDATER.addAndGet(this, hits);
    }

    @Override
    public long getLockedEntryCount() {
        return this.lockedEntryCount;
    }

    public void setLockedEntryCount(long lockedEntryCount) {
        this.lockedEntryCount = lockedEntryCount;
    }

    public void incrementLockedEntryCount(long lockedEntryCount) {
        this.lockedEntryCount += lockedEntryCount;
    }

    @Override
    public long getDirtyEntryCount() {
        return this.dirtyEntryCount;
    }

    public void incrementDirtyEntryCount(long dirtyEntryCount) {
        this.dirtyEntryCount += dirtyEntryCount;
    }

    @Override
    public long total() {
        return this.putCount + this.getCount + this.removeCount + this.numberOfOtherOperations;
    }

    @Override
    public long getPutOperationCount() {
        return this.putCount;
    }

    public void incrementPuts(long latency) {
        PUT_COUNT_UPDATER.incrementAndGet(this);
        TOTAL_PUT_LATENCIES_UPDATER.addAndGet(this, latency);
        MAX_PUT_LATENCY_UPDATER.set(this, Math.max(this.maxPutLatency, latency));
    }

    @Override
    public long getGetOperationCount() {
        return this.getCount;
    }

    public void incrementGets(long latency) {
        GET_COUNT_UPDATER.incrementAndGet(this);
        TOTAL_GET_LATENCIES_UPDATER.addAndGet(this, latency);
        MAX_GET_LATENCY_UPDATER.set(this, Math.max(this.maxGetLatency, latency));
    }

    @Override
    public long getRemoveOperationCount() {
        return this.removeCount;
    }

    public void incrementRemoves(long latency) {
        REMOVE_COUNT_UPDATER.incrementAndGet(this);
        TOTAL_REMOVE_LATENCIES_UPDATER.addAndGet(this, latency);
        MAX_REMOVE_LATENCY_UPDATER.set(this, Math.max(this.maxRemoveLatency, latency));
    }

    @Override
    public long getTotalPutLatency() {
        return this.totalPutLatencies;
    }

    @Override
    public long getTotalGetLatency() {
        return this.totalGetLatencies;
    }

    @Override
    public long getTotalRemoveLatency() {
        return this.totalRemoveLatencies;
    }

    @Override
    public long getMaxPutLatency() {
        return this.maxPutLatency;
    }

    @Override
    public long getMaxGetLatency() {
        return this.maxGetLatency;
    }

    @Override
    public long getMaxRemoveLatency() {
        return this.maxRemoveLatency;
    }

    @Override
    public long getOtherOperationCount() {
        return this.numberOfOtherOperations;
    }

    public void incrementOtherOperations() {
        NUMBER_OF_OTHER_OPERATIONS_UPDATER.incrementAndGet(this);
    }

    @Override
    public long getEventOperationCount() {
        return this.numberOfEvents;
    }

    public void incrementReceivedEvents() {
        NUMBER_OF_EVENTS_UPDATER.incrementAndGet(this);
    }

    public void incrementHeapCost(long heapCost) {
        this.heapCost += heapCost;
    }

    @Override
    public long getHeapCost() {
        return this.heapCost;
    }

    @Override
    public NearCacheStatsImpl getNearCacheStats() {
        return this.nearCacheStats;
    }

    public void setNearCacheStats(NearCacheStatsImpl nearCacheStats) {
        this.nearCacheStats = nearCacheStats;
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 12;
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("getCount", this.getCount);
        root.add("putCount", this.putCount);
        root.add("removeCount", this.removeCount);
        root.add("numberOfOtherOperations", this.numberOfOtherOperations);
        root.add("numberOfEvents", this.numberOfEvents);
        root.add("lastAccessTime", this.lastAccessTime);
        root.add("lastUpdateTime", this.lastUpdateTime);
        root.add("hits", this.hits);
        root.add("ownedEntryCount", this.ownedEntryCount);
        root.add("backupEntryCount", this.backupEntryCount);
        root.add("backupCount", this.backupCount);
        root.add("ownedEntryMemoryCost", this.ownedEntryMemoryCost);
        root.add("backupEntryMemoryCost", this.backupEntryMemoryCost);
        root.add("creationTime", this.creationTime);
        root.add("lockedEntryCount", this.lockedEntryCount);
        root.add("dirtyEntryCount", this.dirtyEntryCount);
        root.add("totalGetLatencies", this.totalGetLatencies);
        root.add("totalPutLatencies", this.totalPutLatencies);
        root.add("totalRemoveLatencies", this.totalRemoveLatencies);
        root.add("maxGetLatency", this.maxGetLatency);
        root.add("maxPutLatency", this.maxPutLatency);
        root.add("maxRemoveLatency", this.maxRemoveLatency);
        root.add("heapCost", this.heapCost);
        if (this.nearCacheStats != null) {
            root.add("nearCacheStats", this.nearCacheStats.toJson());
        }
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        GET_COUNT_UPDATER.set(this, JsonUtil.getLong(json, "getCount", -1L));
        PUT_COUNT_UPDATER.set(this, JsonUtil.getLong(json, "putCount", -1L));
        REMOVE_COUNT_UPDATER.set(this, JsonUtil.getLong(json, "removeCount", -1L));
        NUMBER_OF_OTHER_OPERATIONS_UPDATER.set(this, JsonUtil.getLong(json, "numberOfOtherOperations", -1L));
        NUMBER_OF_EVENTS_UPDATER.set(this, JsonUtil.getLong(json, "numberOfEvents", -1L));
        LAST_ACCESS_TIME_UPDATER.set(this, JsonUtil.getLong(json, "lastAccessTime", -1L));
        LAST_UPDATE_TIME_UPDATER.set(this, JsonUtil.getLong(json, "lastUpdateTime", -1L));
        HITS_UPDATER.set(this, JsonUtil.getLong(json, "hits", -1L));
        this.ownedEntryCount = JsonUtil.getLong(json, "ownedEntryCount", -1L);
        this.backupEntryCount = JsonUtil.getLong(json, "backupEntryCount", -1L);
        this.backupCount = JsonUtil.getInt(json, "backupCount", -1);
        this.ownedEntryMemoryCost = JsonUtil.getLong(json, "ownedEntryMemoryCost", -1L);
        this.backupEntryMemoryCost = JsonUtil.getLong(json, "backupEntryMemoryCost", -1L);
        this.creationTime = JsonUtil.getLong(json, "creationTime", -1L);
        this.lockedEntryCount = JsonUtil.getLong(json, "lockedEntryCount", -1L);
        this.dirtyEntryCount = JsonUtil.getLong(json, "dirtyEntryCount", -1L);
        TOTAL_GET_LATENCIES_UPDATER.set(this, JsonUtil.getLong(json, "totalGetLatencies", -1L));
        TOTAL_PUT_LATENCIES_UPDATER.set(this, JsonUtil.getLong(json, "totalPutLatencies", -1L));
        TOTAL_REMOVE_LATENCIES_UPDATER.set(this, JsonUtil.getLong(json, "totalRemoveLatencies", -1L));
        MAX_GET_LATENCY_UPDATER.set(this, JsonUtil.getLong(json, "maxGetLatency", -1L));
        MAX_PUT_LATENCY_UPDATER.set(this, JsonUtil.getLong(json, "maxPutLatency", -1L));
        MAX_REMOVE_LATENCY_UPDATER.set(this, JsonUtil.getLong(json, "maxRemoveLatency", -1L));
        this.heapCost = JsonUtil.getLong(json, "heapCost", -1L);
        JsonValue jsonNearCacheStats = json.get("nearCacheStats");
        if (jsonNearCacheStats != null) {
            this.nearCacheStats = new NearCacheStatsImpl();
            this.nearCacheStats.fromJson(jsonNearCacheStats.asObject());
        }
    }

    public String toString() {
        return "LocalMapStatsImpl{lastAccessTime=" + this.lastAccessTime + ", lastUpdateTime=" + this.lastUpdateTime + ", hits=" + this.hits + ", numberOfOtherOperations=" + this.numberOfOtherOperations + ", numberOfEvents=" + this.numberOfEvents + ", getCount=" + this.getCount + ", putCount=" + this.putCount + ", removeCount=" + this.removeCount + ", totalGetLatencies=" + this.totalGetLatencies + ", totalPutLatencies=" + this.totalPutLatencies + ", totalRemoveLatencies=" + this.totalRemoveLatencies + ", ownedEntryCount=" + this.ownedEntryCount + ", backupEntryCount=" + this.backupEntryCount + ", backupCount=" + this.backupCount + ", ownedEntryMemoryCost=" + this.ownedEntryMemoryCost + ", backupEntryMemoryCost=" + this.backupEntryMemoryCost + ", creationTime=" + this.creationTime + ", lockedEntryCount=" + this.lockedEntryCount + ", dirtyEntryCount=" + this.dirtyEntryCount + ", heapCost=" + this.heapCost + '}';
    }
}

