/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.EntryViews;
import com.hazelcast.map.MapEntrySet;
import com.hazelcast.map.MapEntrySimple;
import com.hazelcast.map.MapEventPublisher;
import com.hazelcast.map.MapServiceContext;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.operation.AbstractMapOperation;
import com.hazelcast.map.operation.MultipleEntryBackupOperation;
import com.hazelcast.map.record.Record;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MultipleEntryOperation
extends AbstractMapOperation
implements BackupAwareOperation,
PartitionAwareOperation {
    private static final EntryEventType NO_NEED_TO_FIRE_EVENT = null;
    private EntryProcessor entryProcessor;
    private Set<Data> keys;
    private MapEntrySet response;

    public MultipleEntryOperation() {
    }

    public MultipleEntryOperation(String name, Set<Data> keys, EntryProcessor entryProcessor) {
        super(name);
        this.keys = keys;
        this.entryProcessor = entryProcessor;
    }

    @Override
    public void innerBeforeRun() {
        ManagedContext managedContext = this.getNodeEngine().getSerializationService().getManagedContext();
        managedContext.initialize(this.entryProcessor);
    }

    @Override
    public void run() throws Exception {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        this.response = new MapEntrySet();
        InternalPartitionService partitionService = this.getNodeEngine().getPartitionService();
        RecordStore recordStore = mapServiceContext.getRecordStore(this.getPartitionId(), this.name);
        LocalMapStatsImpl mapStats = mapServiceContext.getLocalMapStatsProvider().getLocalMapStatsImpl(this.name);
        for (Data key : this.keys) {
            EntryEventType eventType;
            if (partitionService.getPartitionId(key) != this.getPartitionId()) continue;
            long start = System.currentTimeMillis();
            Object objectKey = mapServiceContext.toObject(key);
            Map.Entry<Data, Object> mapEntry = recordStore.getMapEntry(key);
            Object valueBeforeProcess = mapEntry.getValue();
            Object valueBeforeProcessObject = mapServiceContext.toObject(valueBeforeProcess);
            MapEntrySimple<Object, Object> entry = new MapEntrySimple<Object, Object>(objectKey, valueBeforeProcessObject);
            Object result = this.entryProcessor.process(entry);
            Object valueAfterProcess = entry.getValue();
            Data dataValue = null;
            if (result != null) {
                dataValue = mapServiceContext.toData(result);
                this.response.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(key, dataValue));
            }
            if (valueAfterProcess == null) {
                recordStore.remove(key);
                mapStats.incrementRemoves(this.getLatencyFrom(start));
                eventType = EntryEventType.REMOVED;
            } else {
                if (valueBeforeProcessObject == null) {
                    mapStats.incrementPuts(this.getLatencyFrom(start));
                    eventType = EntryEventType.ADDED;
                } else if (!entry.isModified()) {
                    mapStats.incrementGets(this.getLatencyFrom(start));
                    eventType = NO_NEED_TO_FIRE_EVENT;
                } else {
                    mapStats.incrementPuts(this.getLatencyFrom(start));
                    eventType = EntryEventType.UPDATED;
                }
                if (eventType != NO_NEED_TO_FIRE_EVENT) {
                    recordStore.put(new AbstractMap.SimpleImmutableEntry<Data, Object>(key, valueAfterProcess));
                }
            }
            this.fireEvent(key, valueBeforeProcess, valueAfterProcess, dataValue, recordStore, eventType);
        }
    }

    private void fireEvent(Data key, Object valueBeforeProcess, Object valueAfterProcess, Data dataValue, RecordStore recordStore, EntryEventType eventType) {
        if (eventType == NO_NEED_TO_FIRE_EVENT) {
            return;
        }
        MapServiceContext mapServiceContext = recordStore.getMapContainer().getMapServiceContext();
        Data oldValue = mapServiceContext.toData(valueBeforeProcess);
        Data value = mapServiceContext.toData(valueAfterProcess);
        MapEventPublisher mapEventPublisher = mapServiceContext.getMapEventPublisher();
        mapEventPublisher.publishEvent(this.getCallerAddress(), this.name, eventType, key, oldValue, value);
        if (mapServiceContext.getNearCacheProvider().isNearCacheAndInvalidationEnabled(this.name)) {
            mapServiceContext.getNearCacheProvider().invalidateAllNearCaches(this.name, key);
        }
        if (this.mapContainer.getWanReplicationPublisher() != null && this.mapContainer.getWanMergePolicy() != null) {
            if (EntryEventType.REMOVED.equals((Object)eventType)) {
                mapEventPublisher.publishWanReplicationRemove(this.name, key, Clock.currentTimeMillis());
            } else {
                Record record = recordStore.getRecord(key);
                Data tempValue = mapServiceContext.toData(dataValue);
                EntryView<Data, Data> entryView = EntryViews.createSimpleEntryView(key, tempValue, record);
                mapEventPublisher.publishWanReplicationUpdate(this.name, entryView);
            }
        }
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    public String toString() {
        return "MultipleEntryOperation{}";
    }

    @Override
    public boolean shouldBackup() {
        return this.entryProcessor.getBackupProcessor() != null;
    }

    @Override
    public int getSyncBackupCount() {
        return 0;
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapContainer.getTotalBackupCount();
    }

    @Override
    public Operation getBackupOperation() {
        EntryBackupProcessor backupProcessor = this.entryProcessor.getBackupProcessor();
        return backupProcessor != null ? new MultipleEntryBackupOperation(this.name, this.keys, backupProcessor) : null;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.entryProcessor = (EntryProcessor)in.readObject();
        int size = in.readInt();
        this.keys = new HashSet<Data>(size);
        for (int i = 0; i < size; ++i) {
            Data key = new Data();
            key.readData(in);
            this.keys.add(key);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.entryProcessor);
        out.writeInt(this.keys.size());
        for (Data key : this.keys) {
            key.writeData(out);
        }
    }

    private long getLatencyFrom(long begin) {
        return Clock.currentTimeMillis() - begin;
    }
}

