/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.cluster.ClusterService;
import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapServiceContext;
import com.hazelcast.map.NearCacheProvider;
import com.hazelcast.map.PartitionContainer;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.record.Record;
import com.hazelcast.map.record.RecordStatistics;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.monitor.impl.NearCacheStatsImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.ExceptionUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public class LocalMapStatsProvider {
    private static final int WAIT_PARTITION_TABLE_UPDATE_MILLIS = 100;
    private static final int RETRY_COUNT = 3;
    private final ConcurrentMap<String, LocalMapStatsImpl> statsMap = new ConcurrentHashMap<String, LocalMapStatsImpl>(1000);
    private final ConstructorFunction<String, LocalMapStatsImpl> constructorFunction = new ConstructorFunction<String, LocalMapStatsImpl>(){

        @Override
        public LocalMapStatsImpl createNew(String key) {
            return new LocalMapStatsImpl();
        }
    };
    private final MapServiceContext mapServiceContext;
    private final NodeEngine nodeEngine;

    public LocalMapStatsProvider(MapServiceContext mapServiceContext, NodeEngine nodeEngine) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = nodeEngine;
    }

    public LocalMapStatsImpl getLocalMapStatsImpl(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.statsMap, name, this.constructorFunction);
    }

    public LocalMapStatsImpl createLocalMapStats(String mapName) {
        NodeEngine nodeEngine = this.nodeEngine;
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(mapName);
        LocalMapStatsImpl localMapStats = this.getLocalMapStatsImpl(mapName);
        if (!mapContainer.getMapConfig().isStatisticsEnabled()) {
            return localMapStats;
        }
        int backupCount = mapContainer.getTotalBackupCount();
        ClusterService clusterService = nodeEngine.getClusterService();
        InternalPartitionService partitionService = nodeEngine.getPartitionService();
        Address thisAddress = clusterService.getThisAddress();
        localMapStats.init();
        localMapStats.setBackupCount(backupCount);
        this.addNearCacheStats(localMapStats, mapContainer);
        for (int partitionId = 0; partitionId < partitionService.getPartitionCount(); ++partitionId) {
            InternalPartition partition = partitionService.getPartition(partitionId);
            Address owner = partition.getOwnerOrNull();
            if (owner == null) continue;
            if (owner.equals(thisAddress)) {
                this.addOwnerPartitionStats(localMapStats, mapName, partitionId);
                continue;
            }
            this.addReplicaPartitionStats(localMapStats, mapName, partitionId, partition, clusterService, backupCount, thisAddress);
        }
        return localMapStats;
    }

    private void addOwnerPartitionStats(LocalMapStatsImpl localMapStats, String mapName, int partitionId) {
        RecordStore recordStore = this.getRecordStoreOrNull(mapName, partitionId);
        if (recordStore == null) {
            return;
        }
        int lockedEntryCount = 0;
        long lastAccessTime = 0L;
        long lastUpdateTime = 0L;
        long ownedEntryMemoryCost = 0L;
        long hits = 0L;
        Map<Data, Record> records = recordStore.getReadonlyRecordMap();
        for (Record record : records.values()) {
            hits += this.getHits(record);
            ownedEntryMemoryCost += record.getCost();
            lockedEntryCount += this.isLocked(record, recordStore);
            lastAccessTime = Math.max(lastAccessTime, record.getLastAccessTime());
            lastUpdateTime = Math.max(lastUpdateTime, record.getLastUpdateTime());
        }
        localMapStats.incrementOwnedEntryMemoryCost(ownedEntryMemoryCost);
        localMapStats.incrementLockedEntryCount(lockedEntryCount);
        localMapStats.incrementHits(hits);
        localMapStats.incrementDirtyEntryCount(recordStore.getMapDataStore().notFinishedOperationsCount());
        localMapStats.setLastAccessTime(lastAccessTime);
        localMapStats.setLastUpdateTime(lastUpdateTime);
        localMapStats.incrementHeapCost(recordStore.getHeapCost());
        localMapStats.incrementOwnedEntryCount(records.size());
    }

    private long getHits(Record record) {
        RecordStatistics stats = record.getStatistics();
        return stats.getHits();
    }

    private int isLocked(Record record, RecordStore recordStore) {
        if (recordStore.isLocked(record.getKey())) {
            return 1;
        }
        return 0;
    }

    private void addReplicaPartitionStats(LocalMapStatsImpl localMapStats, String mapName, int partitionId, InternalPartition partition, ClusterService clusterService, int backupCount, Address thisAddress) {
        long heapCost = 0L;
        long backupEntryCount = 0L;
        long backupEntryMemoryCost = 0L;
        for (int replica = 1; replica <= backupCount; ++replica) {
            RecordStore recordStore;
            Address replicaAddress = this.getReplicaAddress(replica, partition, clusterService, backupCount);
            if (this.notGotReplicaAddress(replicaAddress, clusterService, backupCount)) {
                this.printWarning(partition, replica);
                continue;
            }
            if (!this.gotReplicaAddress(replicaAddress, thisAddress) || (recordStore = this.getRecordStoreOrNull(mapName, partitionId)) == null) continue;
            Map<Data, Record> records = recordStore.getReadonlyRecordMap();
            heapCost += recordStore.getHeapCost();
            backupEntryCount += (long)records.size();
            backupEntryMemoryCost += this.getMemoryCost(records);
        }
        localMapStats.incrementHeapCost(heapCost);
        localMapStats.incrementBackupEntryCount(backupEntryCount);
        localMapStats.incrementBackupEntryMemoryCost(backupEntryMemoryCost);
    }

    private boolean notGotReplicaAddress(Address replicaAddress, ClusterService clusterService, int backupCount) {
        return replicaAddress == null && clusterService.getSize() > backupCount;
    }

    private boolean gotReplicaAddress(Address replicaAddress, Address thisAddress) {
        return replicaAddress != null && replicaAddress.equals(thisAddress);
    }

    private void printWarning(InternalPartition partition, int replica) {
        this.nodeEngine.getLogger(this.getClass()).warning("Partition: " + partition + ", replica: " + replica + " has no owner!");
    }

    private long getMemoryCost(Map<Data, Record> records) {
        long cost = 0L;
        for (Record record : records.values()) {
            cost += record.getCost();
        }
        return cost;
    }

    private RecordStore getRecordStoreOrNull(String mapName, int partitionId) {
        PartitionContainer partitionContainer = this.mapServiceContext.getPartitionContainer(partitionId);
        return partitionContainer.getExistingRecordStore(mapName);
    }

    private Address getReplicaAddress(int replica, InternalPartition partition, ClusterService clusterService, int backupCount) {
        Address replicaAddress = partition.getReplicaAddress(replica);
        if (replicaAddress == null) {
            replicaAddress = this.waitForReplicaAddress(replica, partition, clusterService, backupCount);
        }
        return replicaAddress;
    }

    private Address waitForReplicaAddress(int replica, InternalPartition partition, ClusterService clusterService, int backupCount) {
        int tryCount = 3;
        Address replicaAddress = null;
        while (replicaAddress == null && clusterService.getSize() > backupCount && tryCount-- > 0) {
            this.sleep();
            replicaAddress = partition.getReplicaAddress(replica);
        }
        return replicaAddress;
    }

    private void sleep() {
        try {
            TimeUnit.MILLISECONDS.sleep(100L);
        }
        catch (InterruptedException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private void addNearCacheStats(LocalMapStatsImpl localMapStats, MapContainer mapContainer) {
        if (!mapContainer.getMapConfig().isNearCacheEnabled()) {
            return;
        }
        NearCacheProvider nearCacheProvider = this.mapServiceContext.getNearCacheProvider();
        NearCacheStatsImpl nearCacheStats = nearCacheProvider.getNearCache(mapContainer.getName()).getNearCacheStats();
        long nearCacheHeapCost = mapContainer.getNearCacheSizeEstimator().getSize();
        localMapStats.setNearCacheStats(nearCacheStats);
        localMapStats.incrementHeapCost(nearCacheHeapCost);
    }
}

