/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientEngineImpl;
import com.hazelcast.client.ClientExceptionConverter;
import com.hazelcast.client.ClientExceptionConverters;
import com.hazelcast.client.ClientPrincipal;
import com.hazelcast.core.Client;
import com.hazelcast.core.ClientType;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.security.Credentials;
import com.hazelcast.spi.EventService;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.impl.Transaction;
import com.hazelcast.transaction.impl.TransactionAccessor;
import com.hazelcast.transaction.impl.TransactionManagerServiceImpl;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public final class ClientEndpoint
implements Client {
    private final ClientEngineImpl clientEngine;
    private final Connection conn;
    private final ConcurrentMap<String, TransactionContext> transactionContextMap = new ConcurrentHashMap<String, TransactionContext>();
    private final List<Runnable> removeListenerActions = Collections.synchronizedList(new LinkedList());
    private final SocketAddress socketAddress;
    private String uuid;
    private LoginContext loginContext;
    private ClientPrincipal principal;
    private boolean firstConnection;
    private Credentials credentials;
    private volatile boolean authenticated;

    ClientEndpoint(ClientEngineImpl clientEngine, Connection conn, String uuid) {
        this.clientEngine = clientEngine;
        this.conn = conn;
        if (conn instanceof TcpIpConnection) {
            TcpIpConnection tcpIpConnection = (TcpIpConnection)conn;
            this.socketAddress = tcpIpConnection.getSocketChannelWrapper().socket().getRemoteSocketAddress();
        } else {
            this.socketAddress = null;
        }
        this.uuid = uuid;
    }

    Connection getConnection() {
        return this.conn;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    public boolean live() {
        return this.conn.live();
    }

    void setLoginContext(LoginContext loginContext) {
        this.loginContext = loginContext;
    }

    public Subject getSubject() {
        return this.loginContext != null ? this.loginContext.getSubject() : null;
    }

    public boolean isFirstConnection() {
        return this.firstConnection;
    }

    void authenticated(ClientPrincipal principal, Credentials credentials, boolean firstConnection) {
        this.principal = principal;
        this.uuid = principal.getUuid();
        this.firstConnection = firstConnection;
        this.credentials = credentials;
        this.authenticated = true;
    }

    void authenticated(ClientPrincipal principal) {
        this.principal = principal;
        this.uuid = principal.getUuid();
        this.authenticated = true;
        this.clientEngine.addOwnershipMapping(this.uuid, principal.getOwnerUuid());
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public ClientPrincipal getPrincipal() {
        return this.principal;
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        return (InetSocketAddress)this.socketAddress;
    }

    @Override
    public ClientType getClientType() {
        ClientType type;
        switch (this.conn.getType()) {
            case JAVA_CLIENT: {
                type = ClientType.JAVA;
                break;
            }
            case CSHARP_CLIENT: {
                type = ClientType.CSHARP;
                break;
            }
            case CPP_CLIENT: {
                type = ClientType.CPP;
                break;
            }
            case PYTHON_CLIENT: {
                type = ClientType.PYTHON;
                break;
            }
            case RUBY_CLIENT: {
                type = ClientType.RUBY;
                break;
            }
            case BINARY_CLIENT: {
                type = ClientType.OTHER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid connection type: " + (Object)((Object)this.conn.getType()));
            }
        }
        return type;
    }

    public TransactionContext getTransactionContext(String txnId) {
        TransactionContext transactionContext = (TransactionContext)this.transactionContextMap.get(txnId);
        if (transactionContext == null) {
            throw new TransactionException("No transaction context found for txnId:" + txnId);
        }
        return transactionContext;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setTransactionContext(TransactionContext transactionContext) {
        this.transactionContextMap.put(transactionContext.getTxnId(), transactionContext);
    }

    public void removeTransactionContext(String txnId) {
        this.transactionContextMap.remove(txnId);
    }

    public void setListenerRegistration(final String service, final String topic, final String id) {
        this.removeListenerActions.add(new Runnable(){

            @Override
            public void run() {
                EventService eventService = ClientEndpoint.this.clientEngine.getEventService();
                eventService.deregisterListener(service, topic, id);
            }
        });
    }

    public void setDistributedObjectListener(final String id) {
        this.removeListenerActions.add(new Runnable(){

            @Override
            public void run() {
                ClientEndpoint.this.clientEngine.getProxyService().removeProxyListener(id);
            }
        });
    }

    public void clearAllListeners() {
        for (Runnable removeAction : this.removeListenerActions) {
            try {
                removeAction.run();
            }
            catch (Exception e) {
                this.getLogger().warning("Exception during destroy action", e);
            }
        }
        this.removeListenerActions.clear();
    }

    void destroy() throws LoginException {
        for (Runnable removeAction : this.removeListenerActions) {
            try {
                removeAction.run();
            }
            catch (Exception e) {
                this.getLogger().warning("Exception during destroy action", e);
            }
        }
        LoginContext lc = this.loginContext;
        if (lc != null) {
            lc.logout();
        }
        for (TransactionContext context : this.transactionContextMap.values()) {
            Transaction transaction = TransactionAccessor.getTransaction(context);
            if (context.isXAManaged() && transaction.getState() == Transaction.State.PREPARED) {
                TransactionManagerServiceImpl transactionManager = (TransactionManagerServiceImpl)this.clientEngine.getTransactionManagerService();
                transactionManager.addTxBackupLogForClientRecovery(transaction);
                continue;
            }
            try {
                context.rollbackTransaction();
            }
            catch (HazelcastInstanceNotActiveException e) {
                this.getLogger().finest(e);
            }
            catch (Exception e) {
                this.getLogger().warning(e);
            }
        }
        this.authenticated = false;
    }

    private ILogger getLogger() {
        return this.clientEngine.getLogger(this.getClass());
    }

    public void sendResponse(Object response, int callId) {
        Object clientResponseObject;
        boolean isError = false;
        if (response == null) {
            clientResponseObject = new Data();
        } else if (response instanceof Throwable) {
            isError = true;
            ClientExceptionConverter converter = ClientExceptionConverters.get(this.getClientType());
            clientResponseObject = converter.convert((Throwable)response);
        } else {
            clientResponseObject = response;
        }
        this.clientEngine.sendResponse(this, clientResponseObject, callId, isError, false);
    }

    public void sendEvent(Object event, int callId) {
        this.clientEngine.sendResponse(this, event, callId, false, true);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ClientEndpoint{");
        sb.append("conn=").append(this.conn);
        sb.append(", uuid='").append(this.uuid).append('\'');
        sb.append(", firstConnection=").append(this.firstConnection);
        sb.append(", authenticated=").append(this.authenticated);
        sb.append('}');
        return sb.toString();
    }
}

